extern crate redis;
use redis::Commands;
use redis::RedisResult;

use crate::database::db_type::{RIso2WDis, RWDist, WinDistType};

use crate::custom_games::royal231::Royal231;
// use crate::game::builtin::standard2311::Standard2311;
use crate::game::component::*;

const REDIS_URL: &str = "redis://locahost/";

pub trait RedisConnection {
    fn insert_iso_win_id(
        &self,
        batchs: Vec<RIso2WDis>,
    ) -> std::result::Result<(), Box<dyn std::error::Error>>;
    fn insert_winner_dist(
        &self,
        batchs: Vec<RWDist>,
    ) -> std::result::Result<(), Box<dyn std::error::Error>>;

    //fn query_winner_id(&self, iso_id:i64) -> std::result::Result<i64,  Box<dyn std::error::Error>>;
    //fn query_winner_dist(&self, win_dis_id:i64) -> std::result::Result<WinDistType,  Box<dyn std::error::Error>>;
}

impl RedisConnection for Royal231 {
    fn insert_iso_win_id(
        &self,
        batchs: Vec<RIso2WDis>,
    ) -> std::result::Result<(), Box<dyn std::error::Error>> {
        let client = redis::Client::open("redis://127.0.0.1/")?;
        let mut con = client.get_connection().unwrap();
        for item in batchs {
            let z: RedisResult<String> = con.set(item.iso_id, item.win_dist_id);
            //2312_1
            //2312_2
        }
        Ok(())
    }
    fn insert_winner_dist(
        &self,
        batchs: Vec<RWDist>,
    ) -> std::result::Result<(), Box<dyn std::error::Error>> {
        let client = redis::Client::open("redis://127.0.0.1/")?;
        let mut conn = client.get_connection().unwrap();
        for item in batchs {
            //conn.lpush()
            //item.write_redis_args(&mut conn);
            //cmd.write_redis_args(&item.win_dist).unwrap();
            let z: RedisResult<i32> = conn.lpush(item.win_dist_id, &item.win_dist);
            println!("{:?}", z);
        }
        Ok(())
    }
}

pub fn RedisTest() {
    let mut batchs: Vec<RWDist> = Vec::new();
    //let client = redis::Client::open("redis://127.0.0.1/")?;
    //let mut con = client.get_connection().unwrap();

    batchs.push(RWDist::new(13, [1, 2, 3]));
    batchs.push(RWDist::new(53, [2213542, 32345676, 123456]));
    let game: &'static Royal231 = Royal231::instance().as_ref();
    println!("{:?}", game.insert_winner_dist(batchs));
}
