pub struct DealConfig<const N: usize> {
    pub deal_hole_street: [u8; N],
    pub deal_board_street: [u8; N],
}

impl<const N: usize> DealConfig<N> {
    const NUM_STREET: i32 = N as i32;
}

//////////////////////////////////////
pub const fn get_hand_len_street<const N: usize>(
    deal_hole_street: &'static [u8],
    deal_board_street: &'static [u8],
) -> [usize; N] {
    let mut arr = [0; N];
    let mut i = 0;
    while i < N {
        arr[i] = (deal_hole_street[i] + deal_board_street[i]) as usize
            + if i > 0 { arr[i - 1] } else { 0 };
        i += 1;
    }
    arr
}

pub const fn get_card_len_street<const N: usize>(deal_card_street: &'static [u8]) -> [usize; N] {
    let mut arr = [0; N];
    let mut i = 0;
    while i < N {
        arr[i] = deal_card_street[i] as usize + if i > 0 { arr[i - 1] } else { 0 };
        i += 1;
    }
    arr
}

///////////////////////////////////////

pub trait Deal {
    const NUM_STREET: i32;      
    const DEAL_HOLE_STREET: &'static [u8];
    const DEAL_BOARD_STREET: &'static [u8];
    /////////////////// auto
    const HAND_LEN_STREET: &'static [usize];
    const HAND_LEN: usize;
    const HOLE_LEN_STREET: &'static [usize];
    const BOARD_LEN_STREET: &'static [usize];
}
