use itertools::Itertools;

use super::{deck::*, deck::*, hand::*};
pub const LTW: usize = 3; // lose tie win

pub trait ShowdownRanker: Hand {
    fn rank_showdown(hand: &[u8]) -> i32;

    fn showdown_winning_distrubution(hand: &[u8]) -> [i64; LTW] {
        let left_card: Vec<u8> = Vec::from_iter(
            <Self as Deck>::DECK
                .iter()
                .filter(|&&x| !hand.contains(&x))
                .cloned(),
        );

        let mut win_dist = [0 as i64; LTW];

        let my_rank = Self::rank_showdown(hand);

        let mut opponent_hand = Vec::from(hand);
        let opponent_hole_iter = left_card
            .iter()
            .cloned()
            .combinations(Self::HOLE_LEN_STREET[{ Self::NUM_STREET - 1 } as usize]);
        for opponent_hole in opponent_hole_iter {
            Self::change_hole_street(
                { Self::NUM_STREET - 1 } as usize,
                opponent_hand.as_mut_slice(),
                opponent_hole.as_slice(),
            );
            let opponent_rank = Self::rank_showdown(opponent_hand.as_slice());
            if my_rank < opponent_rank {
                win_dist[0] += 1;
            } else if my_rank == opponent_rank {
                win_dist[1] += 1;
            } else {
                win_dist[2] += 1;
            }
        }

        win_dist
    }
}
