#include "hand-isomorphism/deck.h"

// #if defined(STANDARD_POKER)
//     const char RANK_TO_CHAR[] = "23456789TJQKA";
//     const char SUIT_TO_CHAR[] = "shdc";
// #elif defined(ROYAL_POKER)
//     const char RANK_TO_CHAR[] = "TJQKA";
//     const char SUIT_TO_CHAR[] = "shdc";
// #else
//     #error "Some poker type should be defined"
// #endif

#ifdef STANDARD_POKER
    const char RANK_TO_CHAR[] = "23456789TJQKA";
    const char SUIT_TO_CHAR[] = "shdc";
#endif

#ifdef ROYAL_POKER
    const char RANK_TO_CHAR[] = "TJQKA";
    const char SUIT_TO_CHAR[] = "shdc";
#endif

#ifdef NUMERAL_POKER
    const char RANK_TO_CHAR[] = "23456789TA";
    const char SUIT_TO_CHAR[] = "shdc";
#endif

void print_rank_num(){
    printf("SUITS: %d\n", RANKS);
#ifdef STANDARD_POKER
    printf("STANDARD\n");
#endif

#ifdef ROYAL_POKER
    printf("ROYAL\n");
#endif

#ifdef NUMERAL_POKER
    printf("NUMERAL\n");
#endif
}


void print_all_card(){
  for(int rank = 0; rank<RANKS; ++rank){
    for(int suit = 0; suit<SUITS; ++suit){
      printf("suit: %3u, rank: %3u, index: %3u\n", suit, rank, deck_make_card(suit, rank));
    }
  }
  printf("=================\n");
}