#pragma once

template<typename Poker_t>
class XrisoAbstr {
    std::size_t recall_froms[Poker_t::num_rounds];
public:
    XrisoAbstr(const std::vector<std::size_t>& recall_from){
        assert(Poker_t::num_rounds == recall_from.size());
        std::copy(recall_from.begin(), recall_from.end(), std::begin(recall_froms));
    }

    void operator()(int recall_from[Poker_t::num_rounds], uint64_t iso_size_round[Poker_t::num_rounds], uint64_t bucket_size_round[Poker_t::num_rounds], uint64_t* street_bucket[Poker_t::num_rounds]) const {
        std::copy(std::begin(recall_froms), std::end(recall_froms), recall_from);

        for(int r = 0; r < Poker_t::num_rounds; ++r){
            iso_size_round[r] = Hand<Poker_t>::get_isomorphism_size(r, recall_froms[r]);
            bucket_size_round[r] = iso_size_round[r];
            street_bucket[r] = new uint64_t[iso_size_round[r]];
            for (uint32_t iso = 0; iso < bucket_size_round[r]; ++iso) {
                street_bucket[r][iso] = iso;
            }
        }
    }
};