use krwemd_rs::featurizer::Featurizer;
use krwemd_rs::game::builtin::numeral211::{self, Numeral211};
use krwemd_rs::game::component::*;
use krwemd_rs::hand_isomorphism::{hand_indexer_t, hand_unindex, uint_fast32_t};
use krwemd_rs::abstraction_cluster::*;
use std::time::Instant;

type GameType = Numeral211;

// cargo run --example generate_krwemd --features "rust_waugh test_print"

fn main() {
    numeral211::game_specific::setup();

    let cluster_configs = vec![
        vec![
            AbstractAlgorithmStreet::Isomorphism{recall_from:0},
            AbstractAlgorithmStreet::KrwEmd{recall_from: 0, st_weights: vec![5., 3.], centroid_size: 225, train_iteration: 1000},
            AbstractAlgorithmStreet::KrwEmd{recall_from: 0, st_weights: vec![7., 5., 3.], centroid_size: 396, train_iteration: 1000},
        ],
        vec![
            AbstractAlgorithmStreet::Isomorphism{recall_from:0},
            AbstractAlgorithmStreet::KrwEmd{recall_from: 0, st_weights: vec![1., 1.], centroid_size: 225, train_iteration: 1000},
            AbstractAlgorithmStreet::KrwEmd{recall_from: 0, st_weights: vec![1., 1., 1.], centroid_size: 396, train_iteration: 1000},
        ],
        vec![
            AbstractAlgorithmStreet::Isomorphism{recall_from:0},
            AbstractAlgorithmStreet::KrwEmd{recall_from: 0, st_weights: vec![4., 1.], centroid_size: 225, train_iteration: 1000},
            AbstractAlgorithmStreet::KrwEmd{recall_from: 0, st_weights: vec![16., 4., 1.], centroid_size: 396, train_iteration: 1000},
        ],
        vec![
            AbstractAlgorithmStreet::Isomorphism{recall_from:0},
            AbstractAlgorithmStreet::KrwEmd{recall_from: 0, st_weights: vec![5., 7.], centroid_size: 225, train_iteration: 1000},
            AbstractAlgorithmStreet::KrwEmd{recall_from: 0, st_weights: vec![3., 5., 7.], centroid_size: 396, train_iteration: 1000},
        ]
    ];

    for config_idx in 0..4 {
        let start = Instant::now();
        let abstraction = KrwEmdPlusCluster::<GameType>::new(cluster_configs[config_idx].as_ref());
        println!("time costed: {:?}", start.elapsed());
        abstraction.save(&(config_idx+1).to_string());
    }
}