// cargo test --test builtin_numeral211 --features "numeral_poker test_print" -- --show-output
// cargo test --test builtin_numeral211 --features "rust_waugh test_print" -- --show-output

use krwemd_rs::featurizer::Featurizer;
use krwemd_rs::game::builtin::numeral211::{self, Numeral211};
use krwemd_rs::game::component::*;
use krwemd_rs::hand_isomorphism::{hand_indexer_t, hand_unindex, uint_fast32_t};

type GameType = Numeral211;

// cargo run --example generate_pwi_and_krwi --features "rust_waugh test_print"

fn main() {

    numeral211::game_specific::setup();
    let mut ftrzr = Featurizer::<GameType>::new();
    for street_sentinel in (1..=GameType::NUM_STREET).rev() {
        // for street_sentinel in (1..=GameType::NUM_STREET).rev() {
        if street_sentinel < GameType::NUM_STREET {
            println!("===================================================");
            println!("potential: {}", street_sentinel);
            ftrzr.handle_street_potential_distribution(street_sentinel);
        }
        println!("===================================================");
        println!("winning: {}", street_sentinel);
        ftrzr.handle_street_winning_distribution(street_sentinel);
    }

    for street_sentinel in 1..=GameType::NUM_STREET {
        for recall_from_stentinel in 1..street_sentinel {
            println!("===================================================");
            println!("potential: {} from {} ", street_sentinel, recall_from_stentinel);
            ftrzr.handle_street_potential_trace_distribution(street_sentinel, recall_from_stentinel);
            println!("===================================================");
            println!("winning: {} from {}", street_sentinel, recall_from_stentinel);
            ftrzr.handle_street_winning_trace_distribution(street_sentinel, recall_from_stentinel);
        }
    }
}