Graph Canonization Enhanced GNNs
============================

About
-----
In this fold, we provide code to run experiments to test the effectiveness of GC-GNN, i.e. GNNS with graph canonization techniques.

Requirements
------------

Install [PyTorch](https://pytorch.org/)

Install [PyTorch\_Geometric](https://rusty1s.github.io/pytorch_geometric/build/html/notes/installation.html)

Install [OGB](https://ogb.stanford.edu/docs/home/)

Install rdkit by 

    conda install -c conda-forge rdkit


Other required python libraries include are provided in the requirement.txt

Usages
------

### TU dataset

cd GC-GNN
python run_tu_cl_search.py --data all --model all --cuda_id 0 --search


### OGB molecular datasets

cd GC-GNN
python run_ogb_clgnn.py  --dataset ogbg-molhiv --save_appendix _clgin --runs 10 --CO --use_cl

python run_ogb_clgnn.py  --dataset ogbg-molhiv --gnn gcn --save_appendix _clgcn --runs 10 --CO --use_cl



### EXP dataset and CSL datast

cd GC-GNN
python run_exp_cl.py --dataset EXP  --learnRate 0.001 --cuda_id 0 --epochs 65 --model GIN
python run_exp_cl.py --dataset EXP  --learnRate 0.0001 --cuda_id 0 --epochs 100 --model GCN
python run_csl_cl.py --dataset CSL  --learnRate 0.0001 --epochs 300  --model GCN
python run_csl_cl.py --dataset CSL  --learnRate 0.001 --epochs 30  --model GIN

### DAG dataset and Gene networks

cd UCN-GNN

see command.txt
