import numpy as np
import scipy as sp
import sys
from utils import *

import warnings
warnings.filterwarnings('ignore')

ref_parh = "../../camel-gallop/camel-gallop-reference.pose.obj"
task_path = "../../camel-gallop/camel-gallop-"

method_list1 = ['QDOT', 'GW', 'EGW']
method_list2 = ['IQDOT', 'SGW', 'RISGW']

if __name__ == "__main__":
    for method in method_list1:
        print(method)
        myclass = CrossSpaceTask(method)
        myclass.Run_tasks(ref_parh = ref_parh, task_path = task_path, coupling_compare=True)
        myclass.Save_results()
        
    for method in method_list2:
        print(method)
        myclass = CrossSpaceTask(method)
        myclass.Run_tasks(ref_parh = ref_parh, task_path = task_path, coupling_compare=False)
        myclass.Save_results()