
import asyncio
from pathlib import Path

try:
    from playwright.async_api import async_playwright
except ImportError as e:
    print(f"please install playwright: pip install playwright")
    import sys
    sys.exit(1)


async def html_to_image(html_file_path: str, output_path: str = "screenshot.png"):
    
    try:

        async with async_playwright() as p:
            browser = await p.chromium.launch(headless=True)
            
            page = await browser.new_page()
            
            with open(html_file_path, 'r', encoding='utf-8') as f:
                html_content = f.read()
            
            await page.set_content(html_content)
            
            await page.wait_for_timeout(1000)
            
            await page.screenshot(path=output_path, full_page=True)
            
            await browser.close()
            
            print(f"screenshot success: {output_path}")
            return True
            
    except Exception as e:
        print(f"screenshot failed: {e}")
        return False


def html_to_image_sync(html_file_path: str, output_path: str = "screenshot.png"):

    return asyncio.run(html_to_image(html_file_path, output_path))



if __name__ == "__main__":

    html_to_image_sync("test.html", "output.png")
