# Aggregating Capacity in FL through Successive Layer Training for Computationally-Constrained Devices

## Requirements and Datasets
* Installation of the required python packages `pip3 install -r requirements.txt`  
* The datasets CIFAR10/CIFAR100 are automatically downloaded from their public repositories  
* The used version of FEMNIST can be downloaded (anonymous google drive) from https://drive.google.com/file/d/1ZFPbHddOBIkaNZcyezUuKxSSqwaHDdrE/view?usp=share_link The FEMNIST data has to be extracted in the `data/` folder.
* TinyImageNet can be downloaded from http://cs231n.stanford.edu/tiny-imagenet-200.zip and has to be extracted to the `data/` folder.

## Running of experiments
* For each experiment a unique folder gets created where all plots and measurements are stored (`runs/{session_tag}/run_{hash_of_config}`)  

### Run CIFAR10 IID homogeneous experiments
#### SLT and others
* For the baselines Replace `SLT` with `Caldas` or `FedRolex`  

`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm SLT param_scale_factor "[0.125]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm SLT param_scale_factor "[0.125]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm SLT param_scale_factor "[0.125]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm SLT param_scale_factor "[0.25]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm SLT param_scale_factor "[0.25]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm SLT param_scale_factor "[0.25]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm SLT param_scale_factor "[0.5]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm SLT param_scale_factor "[0.5]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm SLT param_scale_factor "[0.5]" seed  13`
#### FedAvg (small model)
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm FedAvg param_scale_factor "[0.125]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm FedAvg param_scale_factor "[0.125]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm FedAvg param_scale_factor "[0.125]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm FedAvg param_scale_factor "[0.25]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm FedAvg param_scale_factor "[0.25]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm FedAvg param_scale_factor "[0.25]" seed  13`    
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm FedAvg param_scale_factor "[0.5]" seed  11`    
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm FedAvg param_scale_factor "[0.5]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm FedAvg param_scale_factor "[0.5]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm FedAvg param_scale_factor "[1.0]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm FedAvg param_scale_factor "[1.0]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param algorithm FedAvg param_scale_factor "[1.0]" seed  13`

### Run CIFAR10 NON-IID homogeneous experiments
#### SLT and others
* For the baselines Replace `SLT` with `Caldas` or `FedRolex`  

`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm SLT param_scale_factor "[0.125]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm SLT param_scale_factor "[0.125]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm SLT param_scale_factor "[0.125]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm SLT param_scale_factor "[0.25]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm SLT param_scale_factor "[0.25]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm SLT param_scale_factor "[0.25]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm SLT param_scale_factor "[0.5]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm SLT param_scale_factor "[0.5]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm SLT param_scale_factor "[0.5]" seed  13`
#### FedAvg (small model)
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.125]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.125]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.125]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.25]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.25]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.25]" seed  13`    
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.5]" seed  11`    
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.5]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.5]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[1.0]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[1.0]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[1.0]" seed  13`

### Run FEMNIST IID homogeneous experiments
#### SLT and others
* For the baselines Replace `SLT` with `Caldas` or `FedRolex`  

`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm SLT param_scale_factor "[0.125]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm SLT param_scale_factor "[0.125]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm SLT param_scale_factor "[0.125]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm SLT param_scale_factor "[0.25]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm SLT param_scale_factor "[0.25]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm SLT param_scale_factor "[0.25]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm SLT param_scale_factor "[0.5]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm SLT param_scale_factor "[0.5]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm SLT param_scale_factor "[0.5]" seed  13`
#### FedAvg (small model)
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm FedAvg param_scale_factor "[0.125]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm FedAvg param_scale_factor "[0.125]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm FedAvg param_scale_factor "[0.125]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm FedAvg param_scale_factor "[0.25]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm FedAvg param_scale_factor "[0.25]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm FedAvg param_scale_factor "[0.25]" seed  13`    
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm FedAvg param_scale_factor "[0.5]" seed  11`    
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm FedAvg param_scale_factor "[0.5]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm FedAvg param_scale_factor "[0.5]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm FedAvg param_scale_factor "[1.0]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm FedAvg param_scale_factor "[1.0]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param algorithm FedAvg param_scale_factor "[1.0]" seed  13`

### Run FEMNIST NON-IID homogeneous experiments
#### SLT and others
* For the baselines Replace `SLT` with `Caldas` or `FedRolex`  

`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm SLT param_scale_factor "[0.125]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm SLT param_scale_factor "[0.125]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm SLT param_scale_factor "[0.125]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm SLT param_scale_factor "[0.25]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm SLT param_scale_factor "[0.25]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm SLT param_scale_factor "[0.25]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm SLT param_scale_factor "[0.5]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm SLT param_scale_factor "[0.5]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm SLT param_scale_factor "[0.5]" seed  13`
#### FedAvg (small model)
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm FedAvg param_scale_factor "[0.125]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm FedAvg param_scale_factor "[0.125]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm FedAvg param_scale_factor "[0.125]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm FedAvg param_scale_factor "[0.25]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm FedAvg param_scale_factor "[0.25]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm FedAvg param_scale_factor "[0.25]" seed  13`    
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm FedAvg param_scale_factor "[0.5]" seed  11`    
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm FedAvg param_scale_factor "[0.5]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm FedAvg param_scale_factor "[0.5]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm FedAvg param_scale_factor "[1.0]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm FedAvg param_scale_factor "[1.0]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_femnist.json --param dataset noniid_FEMNIST algorithm FedAvg param_scale_factor "[1.0]" seed  13`


### Run CIFAR100 IID homogeneous experiments
#### SLT and others
* For the baselines Replace `SLT` with `Caldas` or `FedRolex`  

`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm SLT param_scale_factor "[0.33]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm SLT param_scale_factor "[0.33]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm SLT param_scale_factor "[0.33]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm SLT param_scale_factor "[0.66]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm SLT param_scale_factor "[0.66]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm SLT param_scale_factor "[0.66]" seed  13`  
#### FedAvg (small model)
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm FedAvg param_scale_factor "[0.33]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm FedAvg param_scale_factor "[0.33]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm FedAvg param_scale_factor "[0.33]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm FedAvg param_scale_factor "[0.66]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm FedAvg param_scale_factor "[0.66]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm FedAvg param_scale_factor "[0.66]" seed  13`    
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm FedAvg param_scale_factor "[1.0]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm FedAvg param_scale_factor "[1.0]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param algorithm FedAvg param_scale_factor "[1.0]" seed  13`

### Run CIFAR100 NON-IID homogeneous experiments
#### SLT and others
* For the baselines Replace `SLT` with `Caldas` or `FedRolex`  

`python3 run_fl.py --path settings/fl_setting_cifar100.json --param dataset noniid_CIFAR100 algorithm SLT param_scale_factor "[0.33]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param dataset noniid_CIFAR100 algorithm SLT param_scale_factor "[0.33]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param dataset noniid_CIFAR100 algorithm SLT param_scale_factor "[0.33]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param dataset noniid_CIFAR100 algorithm SLT param_scale_factor "[0.66]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param dataset noniid_CIFAR100 algorithm SLT param_scale_factor "[0.66]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param dataset noniid_CIFAR100 algorithm SLT param_scale_factor "[0.66]" seed  13`  

#### FedAvg (small model)
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.33]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.33]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.33]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.66]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.66]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[0.66]" seed  13`    
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[1.0]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[1.0]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar10.json --param dataset noniid_CIFAR10 algorithm FedAvg param_scale_factor "[1.0]" seed  13`


### Run TinyImageNet IID homogeneous experiments
#### SLT and others
* For the baselines Replace `SLT` with `Caldas` or `FedRolex`  

`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm SLT param_scale_factor "[0.125]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm SLT param_scale_factor "[0.125]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm SLT param_scale_factor "[0.125]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm SLT param_scale_factor "[0.25]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm SLT param_scale_factor "[0.25]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm SLT param_scale_factor "[0.25]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm SLT param_scale_factor "[0.5]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm SLT param_scale_factor "[0.5]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm SLT param_scale_factor "[0.5]" seed  13`
#### FedAvg (small model)
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm FedAvg param_scale_factor "[0.125]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm FedAvg param_scale_factor "[0.125]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm FedAvg param_scale_factor "[0.125]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm FedAvg param_scale_factor "[0.25]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm FedAvg param_scale_factor "[0.25]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm FedAvg param_scale_factor "[0.25]" seed  13`    
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm FedAvg param_scale_factor "[0.5]" seed  11`    
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm FedAvg param_scale_factor "[0.5]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm FedAvg param_scale_factor "[0.5]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm FedAvg param_scale_factor "[1.0]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm FedAvg param_scale_factor "[1.0]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param algorithm FedAvg param_scale_factor "[1.0]" seed  13`

### Run TinyImageNet NON-IID homogeneous experiments
#### SLT and others
* For the baselines Replace `SLT` with `Caldas` or `FedRolex`  

`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm SLT param_scale_factor "[0.125]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm SLT param_scale_factor "[0.125]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm SLT param_scale_factor "[0.125]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm SLT param_scale_factor "[0.25]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm SLT param_scale_factor "[0.25]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm SLT param_scale_factor "[0.25]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm SLT param_scale_factor "[0.5]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm SLT param_scale_factor "[0.5]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm SLT param_scale_factor "[0.5]" seed  13`
#### FedAvg (small model)
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.125]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.125]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.125]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.25]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.25]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.25]" seed  13`    
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.5]" seed  11`    
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.5]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.5]" seed  13`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[1.0]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[1.0]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[1.0]" seed  13`


### Run CIFAR100 NON-IID heterogeneous experiments
#### SLT and others
* For the baselines Replace `SLT` with `Caldas`, `FedRolex`, `HeteroFL`, or `FjORD`

`python3 run_fl.py --path settings/fl_setting_cifar100.json --param dataset noniid_CIFAR100 algorithm SLT param_scale_factor "[0.33, 0.66]" seed  11`    
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param dataset noniid_CIFAR100 algorithm SLT param_scale_factor "[0.33, 0.66]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param dataset noniid_CIFAR100 algorithm SLT param_scale_factor "[0.33, 0.66]" seed  13`    
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param dataset noniid_CIFAR100 algorithm SLT param_scale_factor "[0.33, 0.66, 1.0]" seed  11`    
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param dataset noniid_CIFAR100 algorithm SLT param_scale_factor "[0.33, 0.66, 1.0]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_cifar100.json --param dataset noniid_CIFAR100 algorithm SLT param_scale_factor "[0.33, 0.66, 1.0]" seed  13`    


### Run TINYIMAGENET NON-IID heterogeneous experiments
#### SLT and others
* For the baselines Replace `SLT` with `Caldas`, `FedRolex`, `HeteroFL`, or `FjORD`

`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.125, 0.25]" seed  11`    
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.125, 0.25]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.125, 0.25]" seed  13`   
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.125, 0.25, 0.5]" seed  11`    
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.125, 0.25, 0.5]" seed  12`    
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.125, 0.25, 0.5]" seed  13`   
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.125, 0.25, 0.5, 1.0]" seed  11`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.125, 0.25, 0.5, 1.0]" seed  12`  
`python3 run_fl.py --path settings/fl_setting_tinyimagenet.json --param dataset noniid_TINYIMAGENET algorithm FedAvg param_scale_factor "[0.125, 0.25, 0.5, 1.0]" seed  13`


## Running Memory Measurements
* memory measurements can be done using `python3 memory/memory_configs.py`. The program accepts the different evaluated nets as input. The options can be shown with  `python3 memory/memory_configs.py --help`. Configs have to be added manually, and after finding sufficient configs, they have to be manually copied in the respective files in `nets/SLTNets/configs/...`
