## Environment Setup

PyTorch Version -
```
torch==1.11.0
```

## Preparing Datasets

#### Folktables Dataset
Install the `folktables` package from https://github.com/zykls/folktables.

#### CelebA Dataset
1. Download `CelebA` dataset from https://mmlab.ie.cuhk.edu.hk/projects/CelebA.html.
2. Use `freeze_features.py` to extract features from ResNet50 backbone. These features will be loaded directly during training.

## Training Models

Run `train.py` to train individual models.

Refer to `example_train.sh` to train multiple models.

## Example Evaluation : Plotting Raw Distributions

Refer to various modes in `evaluate.py` to replicate different experiments presented in our paper.

We provide an example to create raw distribution of sampling across multiple training runs and sampling across epochs in a single training run. (Note : Trained models are not included in this codebase. Use previous steps to first train appropriate models)

```
python evaluate.py --mode figure_sampling_violin --cuda --gpus 0 --ckptfldr folktablesSGD --ckptloss ce --outplot outplot_name.pdf
```
