### Environment
`Python 3.10` is recommended. Before running the code, export your OpenAI API key :
```bash
export OPENAI_API_KEY="<your OpenAI api key>".
```


### Installation
Install the required packages:
```bash
pip install -r requirement.txt
```
### Running the Pipeline
Run the full pipeline, which performs probing, trains the classifier, and evaluates the results, using a Llama 1B model with this command:
```bash
python src/run.py --model_name meta-llama/Llama-3.2-1B-Instruct --data_dir "data/short" --output_dir "./results"
```


### Configuration
To adjust configuration parameters, such as the `number of data points`, `number of heads`, `classification threshold`, or `evaluation methods`, please edit the following:
```bash
src/config.py
```
