### Setup

1) Install [poetry](https://python-poetry.org/docs/) (the code has been tested with Python version 3.10.14).

2) Run "poetry install --extras simulation" in the folder containing pyproject.toml to install modified Flower and all dependencies (the tested code simulates FL clients without running on actual devices).

3) Download the pre-trained [ResNeXt-29 8x64 weights](https://github.com/bearpaw/pytorch-classification), and point torch.load to the correct file (line 23 in models.py).

### For running the code:

Privacy accounting (implemented in dp_accounting.py) should be done as a separate step before running the main file to find the correct noise level. Different configurations can be found at the bottom of the file.

If the data does not have inherent splits, check the argparser options in create_client_data.py and use 'poetry run python create_client_data.py' to save the data splits.

The main file for running all experiments is federated_learning_main.py. Before running, check the (longish) list of argparser options at the end of the file to set the configuration. To run experiments with fixed configurations used in the paper, use the provided config files (giving config file name for argparser overwrites the corresponding default options).

### Code Acknowledgements

The main code is build on top of [Flower](https://github.com/adap/flower) to run federated learning in a simulation mode. The Skellam mechanism implementation and accounting is based on the code from https://github.com/facebookresearch/dp_compression.