#!/bin/bash

# SCRIPT_PATH =  "/home/zhu.3723/kronvit/"
cd /home/zhu.3723/kronvit/
GPU_NUM=2
export OMP_NUM_THREADS=1
export CUDA_VISIBLE_DEVICES=6,7


start_time=$(date +"%s") 

torchrun --nproc_per_node=$GPU_NUM \
     --master_port 29510\
      main.py \
     --epochs 300 \
     --model normal_swin_tiny_patch4_window7_224 \
     --batch-size 256 \
     --data-set CIFAR \
     --data-path /local/storage/ding/cifar100 \
     --lr 1e-3\
     --output_dir /home/zhu.3723/kronvit/output/cifar100/swin \
     --finetune  /home/zhu.3723/kronvit/output/cifar100/swin/best_checkpoint.pth \
     
     

end_time=$(date +"%s")

# Calculate and echo the total time taken
elapsed_time=$((end_time - start_time))
echo "Total execution time: $elapsed_time seconds"