import torch 
import torch.nn as nn
import torch.optim as optim
import torch.nn.functional as F

import torchvision
import torchvision.transforms as transforms
from sklearn.model_selection import KFold
import pickle
import random
from models.LinearModel import KronLinear
from utils.metric import test_accuracy

import argparse

parser = argparse.ArgumentParser(description='KPD')
# parser.add_argument('--glambda', type=float, default=0.0001, help='lasso lambda')

lasso_lambda = 0.0001


#using 5-fold of mnist
random_seed = 42
torch.manual_seed(random_seed)
random.seed(random_seed)
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")

train_mnist = torchvision.datasets.MNIST(root='./data', train=True, download=True, transform=transforms.ToTensor())
test_mnist = torchvision.datasets.MNIST(root='./data', train=False, download=True, transform=transforms.ToTensor())

full_dataset = torch.utils.data.ConcatDataset([train_mnist, test_mnist])
kf = KFold(n_splits=5, shuffle=True)
batch_size = 1024


device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
class OneLayer(nn.Module):
    def __init__(self):
        super(OneLayer, self).__init__()
        self.kronlinear = KronLinear(784, 10, patchsize=(4, 2), structured_sparse=True, rank=2)
        self.activation = nn.Sigmoid()
    def forward(self, x):
        x = x.view(-1, 784)
        return self.activation(self.kronlinear(x))



# calculate the parameter and flops 
model = OneLayer()
from ptflops import get_model_complexity_info
with torch.cuda.device(0):
    macs, params = get_model_complexity_info(model, (1, 784), as_strings=True, backend='pytorch',print_per_layer_stat=True, verbose=True)
    print(macs*2, params)
sparsity_thresold = 0.9

def train_test(model, ):
    
    

    accuracy = []
    sparse = []
    weights = []
    for fold, (train_index, test_index) in enumerate(kf.split(full_dataset)):
        model = OneLayer()
        model = model.to(device)
        optimizer = optim.SGD(model.parameters(), lr=0.01, momentum=0.9)
        lasso_lambda = 2
        lambda_p = 1
        train_loader = torch.utils.data.DataLoader(torch.utils.data.Subset(full_dataset, train_index), batch_size=batch_size, shuffle=True)
        test_loader = torch.utils.data.DataLoader(torch.utils.data.Subset(full_dataset, test_index), batch_size=batch_size, shuffle=True)
        
        for epoch in range(250):
            for i, (x, y) in enumerate(train_loader):
                x = x.to(device)
                y = y.to(device)
                optimizer.zero_grad()
                output = model(x)
                loss = F.cross_entropy(output, y)
                # print(loss, torch.norm(model.kronlinear.s, p=1) / torch.numel(model.kronlinear.s) * lasso_lambda * lambda_p)

                loss += torch.norm(model.kronlinear.s, p=1) / torch.numel(model.kronlinear.s) * lasso_lambda * lambda_p
                
                loss.backward()
                optimizer.step()
           
            if epoch % 5 == 0:
                spars = torch.sum(torch.abs(model.kronlinear.s)< 1e-4) / torch.numel(model.kronlinear.s)
                print(torch.sum(torch.abs(model.kronlinear.s)< 1e-4)/torch.numel(model.kronlinear.s))
                if spars < sparsity_thresold:
                    lambda_p += 0.1
        print(torch.sum(torch.abs(model.kronlinear.s)< 1e-4)/torch.numel(model.kronlinear.s))
            # if epoch % 2 == 0:
                # spars = torch.sum(torch.abs(model.kronlinear.s)< 1e-5) / torch.numel(model.kronlinear.s)
                # print(torch.sum(torch.abs(model.kronlinear.s)< 1e-5), torch.numel(model.kronlinear.s))
                # if spars < sparsity_thresold:
                #     lasso_lambda *= 1.1
                # if i % 100 == 0:
                #     print(f'iteration {i}, loss {loss.item()}')
        
        with torch.no_grad():
            correct = 0 
            
            total = 0
            weights.append(model.kronlinear.s)

            for i, (x, y) in enumerate(test_loader):
                x = x.to(device)
                y = y.to(device)
                output = model(x)
                _, predicted = torch.max(output, 1)
                total += y.size(0)
                correct += (predicted == y).sum().item()
                
            print(f'kronlinear fold {fold} accuracy: {correct/total}')
           
            with open(f'./results/accuracy.pkl', 'wb') as f:
                f.write(pickle.dumps(correct/total))

            accuracy.append(correct/total)

        total_params = torch.numel(model.kronlinear.s) 
        zero_params = torch.sum(torch.abs(model.kronlinear.s)< 1e-4)
        
        print('linear1 zero params:', torch.sum(torch.abs(model.kronlinear.s) < 1e-4).detach().cpu().numpy(), 'linear1 s numels:', torch.numel(model.kronlinear.s), 'sparsity:', (zero_params / total_params).detach().cpu().numpy())
        

        
        # zero_params to int

        zero_params = zero_params.item()
        sparsity = zero_params / total_params
        sparse.append(sparsity)
        #save weights and sparsity array
        with open(f'./results/one_layer_KPD_{fold}.pkl', 'wb') as f:
            f.write(pickle.dumps((weights, sparse)))
        torch.save(model.state_dict(), f'./results/one_layer_KPD_{fold}.pth')
    import numpy as np
    accuracy = np.array(accuracy)
    print(np.mean(accuracy[0::2]), np.std(accuracy[0::2]))
    print(np.mean(accuracy[1::2]), np.std(accuracy[1::2]))
        
    print(np.mean(sparse), np.std(sparse))
    return accuracy

model = OneLayer()

train_test(model)
