#!/bin/bash

# SCRIPT_PATH =  "/home/zhu.3723/kronvit/"
cd /home/zhu.3723/kronvit/
GPU_NUM=2
export OMP_NUM_THREADS=2
export CUDA_VISIBLE_DEVICES=2,3


start_time=$(date +"%s") 

torchrun --nproc_per_node=$GPU_NUM \
     --master_port 29520\
      main.py \
     --epochs 300 \
     --model kron_swin_tiny_patch4_window7_224 \
     --batch-size 128 \
     --data-set CIFAR \
     --data-path /home/zhu.3723/data/cifar100 \
     --lr 1e-4\
     --output_dir /home/zhu.3723/kronvit/output/cifar100_kron/kron_swin_2-2rank4 \
     --finetune /home/zhu.3723/kronvit/output/cifar100_kron/kron_swin_2-2rank4/best_checkpoint.pth \
     # --data-path /local/storage/ding/cifar100 \
     

end_time=$(date +"%s")

# Calculate and echo the total time taken
elapsed_time=$((end_time - start_time))
echo "Total execution time: $elapsed_time seconds"