import torch 
import torch.nn as nn
import torch.optim as optim
import torch.nn.functional as F

import torchvision
import torchvision.transforms as transforms
from sklearn.model_selection import KFold
import pickle
import random
from compressor import Compressor

from torchsummary import summary
from utils.loss import  group_pattern
#using 5-fold of mnist
random_seed = 40
torch.manual_seed(random_seed)
random.seed(random_seed)
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")

train_mnist = torchvision.datasets.MNIST(root='./data', train=True, download=True, transform=transforms.ToTensor())
test_mnist = torchvision.datasets.MNIST(root='./data', train=False, download=True, transform=transforms.ToTensor())

full_dataset = torch.utils.data.ConcatDataset([train_mnist, test_mnist])
kf = KFold(n_splits=5, shuffle=True)
batch_size = 4096


# device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
device = torch.device("cpu")
class LeNet(nn.Module):
    def __init__(self):
        super(LeNet, self).__init__()
        self.conv1 = nn.Conv2d(1, 6, 5, padding=2)
        self.conv2 = nn.Conv2d(6, 16, 5)
        self.fc1 = nn.Linear(16*5*5, 120)
        self.fc2 = nn.Linear(120, 84)
        self.fc3 = nn.Linear(84, 10)
        
    def forward(self, x):
        x = F.max_pool2d(F.relu(self.conv1(x)), 2)
        x = F.max_pool2d(F.relu(self.conv2(x)), 2)
        x = x.view(-1, 16*5*5)
        x = F.relu(self.fc1(x))
        x = F.relu(self.fc2(x))
        x = self.fc3(x)
        return x

# calculate the parameter and flops 
model = LeNet()
from ptflops import get_model_complexity_info
with torch.cuda.device(0):
    macs, params = get_model_complexity_info(model, (1, 28, 28), as_strings=True, backend='pytorch',print_per_layer_stat=True, verbose=True)
    print(macs*2, params)
patch_size = [
    [4, 5], [5, 12], [12, 2]
]

print(summary(model, (1, 28, 28), device='cpu'))


import numpy as np
patch_size= np.array(patch_size)
patch_size = patch_size[:,::-1]

print(patch_size)
def group_lasso(model, pattern):
    l2_regularization = torch.norm(group_pattern(pattern[0], pattern[1], mat=model.weight),p=2, dim=1)
    l1_regularization = torch.norm(l2_regularization, p=1)
    return l1_regularization

def train_test(model, ):
    model = model.to(device)
    compressor = Compressor(model, cuda=False)
    optimizer = optim.SGD(model.parameters(), lr=0.01, momentum=0.9)
    lasso_lambda = 0.001

    accuracy = []
    sparse = []
    weights = []
    for fold, (train_index, test_index) in enumerate(kf.split(full_dataset)):
        train_loader = torch.utils.data.DataLoader(torch.utils.data.Subset(full_dataset, train_index), batch_size=batch_size, shuffle=True)
        test_loader = torch.utils.data.DataLoader(torch.utils.data.Subset(full_dataset, test_index), batch_size=batch_size, shuffle=True)
        
        for epoch in range(50):
            for i, (x, y) in enumerate(train_loader):
                x = x.to(device)
                y = y.to(device)
                optimizer.zero_grad()
                output = model(x)
                loss = F.cross_entropy(output, y)
                # print(loss.detach().cpu().numpy())
                
                # print(l1_regularization.detach().cpu().numpy())

                loss.backward()
                optimizer.step()
            if epoch % 5 == 0:
            
                new_pct_pruned = compressor.prune()
                import logging
                logging.info('Pruned %.3f %%' % (100 * new_pct_pruned))
                compressor.set_grad()

        def get_sparsity(model):
            total = 0
            sparsity = 0
            for name, param in model.named_parameters():
                if 'weight' in name:
                    total += param.numel()
                    sparsity += torch.sum(param <= 1e-4).item()
                    
            return sparsity/total
        with torch.no_grad():
            total = 0
            correct = 0
            for i, (x, y) in enumerate(test_loader):
                x = x.to(device)
                y = y.to(device)
                output = model(x)
                _, predicted = torch.max(output, 1)
                total += y.size(0)
                correct += (predicted == y).sum().item()
            print(f'fold {fold} accuracy: {correct/total}')
            accuracy.append(correct/total)
            print(get_sparsity(model))
            sparse.append(get_sparsity(model))

        # zero_params to int

    import numpy as np
    accuracy = np.array(accuracy)
    print(np.mean(accuracy), np.std(accuracy))
    
    print(np.mean(sparse), np.std(sparse))
    return accuracy


model = LeNet()


train_test(model)
