import torch 
import torch.nn as nn
import torch.optim as optim
import torch.nn.functional as F

import torchvision
import torchvision.transforms as transforms
from sklearn.model_selection import KFold
import pickle
import random
from models.LinearModel import KronLinear

from utils.loss import get_s_norm

import argparse

parser = argparse.ArgumentParser(description='KPD')
# parser.add_argument('--glambda', type=float, default=0.0001, help='lasso lambda')

lasso_lambda = 0.0005
def get_sparsity(model):
    from models.LinearModel import KronLinear
    total = 0
    zero = 0
    for name, _module in model._modules.items():
        if isinstance(_module, KronLinear):
            total += _module.s.numel()
            zero += (_module.s < 1e-3).sum().item()
    return zero/total


#using 5-fold of mnist
random_seed = 42
torch.manual_seed(random_seed)
random.seed(random_seed)
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")

train_mnist = torchvision.datasets.MNIST(root='./data', train=True, download=True, transform=transforms.ToTensor())
test_mnist = torchvision.datasets.MNIST(root='./data', train=False, download=True, transform=transforms.ToTensor())

full_dataset = torch.utils.data.ConcatDataset([train_mnist, test_mnist])
kf = KFold(n_splits=5, shuffle=True)
batch_size = 1024

patchsize = [
   [16,8],
   [8,4],
   [4,2]
]

 


device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
class LeNet(nn.Module):
    def __init__(self):
        super(LeNet, self).__init__()
        self.conv1 = nn.Conv2d(1, 6, 5)
        self.conv2 = nn.Conv2d(6, 16, 5)
        self.fc1 = KronLinear(16*4*4, 120, patchsize=patchsize[0], rank=5,structured_sparse=True)
        self.fc2 = KronLinear(120, 84, patchsize=patchsize[1], rank=5, structured_sparse=True)
        self.fc3 = KronLinear(84, 10, patchsize=patchsize[2], rank=5, structured_sparse=True)
    def forward(self, x):
        x = F.max_pool2d(F.relu(self.conv1(x)), 2)
        x = F.max_pool2d(F.relu(self.conv2(x)), 2)
        x = x.view(-1, 16*4*4)
        x = F.relu(self.fc1(x))
        x = F.relu(self.fc2(x))
        x = self.fc3(x)
        return x


# calculate the parameter and flops 
model = LeNet()
from ptflops import get_model_complexity_info
with torch.cuda.device(0):
    macs, params = get_model_complexity_info(model, (1, 28, 28), as_strings=True, backend='pytorch',print_per_layer_stat=True, verbose=True)
    print(macs*2, params)

from utils.metric import get_param_num
print(get_param_num(model))
from torchsummary import summary
print(summary(model, (1, 28, 28), device='cpu'))
def train_test(model, ):
    model = model.to(device)
    optimizer = optim.SGD(model.parameters(), lr=0.01, momentum=0.9)
    lasso_lambda = 0.0001

    accuracy = []
    sparse = []
    weights = []
    for fold, (train_index, test_index) in enumerate(kf.split(full_dataset)):
        train_loader = torch.utils.data.DataLoader(torch.utils.data.Subset(full_dataset, train_index), batch_size=batch_size, shuffle=True)
        test_loader = torch.utils.data.DataLoader(torch.utils.data.Subset(full_dataset, test_index), batch_size=batch_size, shuffle=True)
        
        for epoch in range(50):
            for i, (x, y) in enumerate(train_loader):
                x = x.to(device)
                y = y.to(device)
                optimizer.zero_grad()
                output = model(x)
                loss = F.cross_entropy(output, y)
                # print(lasso_lambda * get_s_norm(model))
                loss += lasso_lambda * get_s_norm(model)
                loss.backward()
                optimizer.step()
                # if i % 100 == 0:
                #     print(f'iteration {i}, loss {loss.item()}')
        
        with torch.no_grad():
            correct = 0 
            
            total = 0
            

            for i, (x, y) in enumerate(test_loader):
                x = x.to(device)
                y = y.to(device)
                output = model(x)
                _, predicted = torch.max(output, 1)
                total += y.size(0)
                correct += (predicted == y).sum().item()
                
            print(f'kronlinear fold {fold} accuracy: {correct/total}')
           
            with open(f'./results/accuracy.pkl', 'wb') as f:
                f.write(pickle.dumps(correct/total))

            accuracy.append(correct/total)
            sparse.append(get_sparsity(model))

       
        
        
        
        
        # zero_params to int

        
    import numpy as np
    accuracy = np.array(accuracy)
    print(np.mean(accuracy[0::2]), np.std(accuracy[0::2]))
    print(np.mean(accuracy[1::2]), np.std(accuracy[1::2]))
        
    print(np.mean(sparse), np.std(sparse))
    return accuracy

model = LeNet()

train_test(model)

def get_sparsity(model):
    from models.LinearModel import KronLinear
    total = 0
    zero = 0
    for name, _module in model._modules.items():
        if isinstance(_module, KronLinear):
            total += _module.s.numel()
            zero += (_module.s < 1e-3).sum().item()
    return zero/total
