%% Set plot points

a0 = (0.005:0.005:2)';
a1 = (0.005:0.005:2);

g0 = (0.005:0.005:2)';
g1 = (0.005:0.005:2);


%% Set color scheme

% Check for ColorBrewer maps
if exist('cbrewer.m', 'file') == 2
    cmp = cbrewer('seq','Blues',2^16);
else
    warning('ColorBrewer colormaps not found; using MATLAB default.')
    cmp = parula(2^16);
end

corder = [    0.9882    0.5529    0.3490
    1.0000    1.0000    0.7490
    0.6000    0.8353    0.5804];

bcolor = [0.8706    0.1765    0.1490];
% bcolor = 'r';


%% Plot phase diagram in (a0,a1) coordinates

genErrTh = 1 .* (a0 > 1 & a1 > 1)...
    + 2 .* (a1 < 1 & a1 < a0) ...
    + 3 .* (a0 < 1 & a0 < a1);

figure('Position',[200,500,500,700],'WindowStyle','docked');
hold on
imagesc(a0, a1, genErrTh');
axis('xy','square');
colormap(corder);
caxis([1 3]);
xlim([min(a0), max(a0)])
ylim([min(a1), max(a1)])
xlabel('\alpha_0');
ylabel('\alpha_1');
set(gca, 'FontSize', 16, 'LineWidth', 2, 'Box','off','tickdir','out');

plot(0:0.01:1, 0:0.01:1, 'Color', bcolor,'linewidth', 2);
plot(1:0.01:2, ones(length(1:0.01:2)),  'Color', bcolor,'linewidth', 2);
plot(ones(length(1:0.01:2)), 1:0.01:2,  'Color', bcolor,'linewidth', 2);


%% Plot phase diagram in (1/a0,a1/a0) coordinates

genErrTh = 1 .* (g0 < min(1,g1))...
    + 2 .* (g1 < 1 & g0 > g1) ...
    + 3 .* (g0 > 1 & g1 >= 1);

figure('Position',[200,500,500,700],'WindowStyle','docked');
hold on
imagesc(g0,g1, genErrTh');
axis('xy','square');
colormap(corder);
caxis([1 3]);
xlim([min(g0), max(g0)])
ylim([min(g1), max(g1)])

xlabel('1/\alpha_0');
ylabel('\alpha_1/\alpha_0');
set(gca, 'FontSize', 16, 'LineWidth', 2, 'Box','off','tickdir','out');

plot(0:0.01:1, 0:0.01:1, 'Color', bcolor,'linewidth', 2);
plot(1:0.01:2, ones(length(1:0.01:2)),  'Color', bcolor,'linewidth', 2);
plot(ones(length(1:0.01:2)), 1:0.01:2,  'Color', bcolor,'linewidth', 2);

%% Plot phase diagram without label noise, unstructured

% Label noise
eta = 0;

genErrTh = ((1 + 1./(g1./g0.*(g1>g0) - 1)) .* (1 - g0) + eta^2 * ( 1./(g1./g0.*(g1>g0) - 1) + 1./(1./g0.*(g0<1)-1))) .* (g0 < min(1,g1))...
    + (1./(1-g1./g0.*(g1<g0)) .* (1-g1) + eta^2*g1./g0./(1-g1./g0.*(g1<g0))).* (g1 < 1 & g0 > g1) ...
    + (eta^2 * 1./(g0.*(g0 ~= 1)-1)) .* (g0 > 1 & g1 >= 1) ...
    + 1e8*(g1 < 1 & g0 == g1) + 1e8*(g1 >= 1 & g0 == 1 & eta>0);


figure('Position',[200,500,500,700],'WindowStyle','docked');
hold on
imagesc(g0, g1, genErrTh');
contour(g0, g1, genErrTh', 0:0.5:5, 'LineColor','k','LineWidth', 2);

axis('xy','square');
clim([0 5]);
colormap(cmp);
xlabel('1/\alpha_0');
ylabel('\alpha_1/\alpha_0');
cbar = colorbar;
ylabel(cbar, '\epsilon');
title(sprintf('L=1, unstructured, \\eta = %0.2f', eta));
set(gca, 'FontSize', 16, 'LineWidth', 2, 'Box','off','tickdir','out');

plot(0:0.01:1, 0:0.01:1, 'Color', bcolor,'linewidth', 2);
plot(1:0.01:2, ones(length(1:0.01:2)),  'Color', bcolor,'linewidth', 2);
plot(ones(length(1:0.01:2)), 1:0.01:2,  'Color', bcolor,'linewidth', 2);

%% Plot phase diagram with label noise, unstructured

% Label noise
eta = 0.5;

genErrTh = ((1 + 1./(g1./g0.*(g1>g0) - 1)) .* (1 - g0) + eta^2 * ( 1./(g1./g0.*(g1>g0) - 1) + 1./(1./g0.*(g0<1)-1))) .* (g0 < min(1,g1))...
    + (1./(1-g1./g0.*(g1<g0)) .* (1-g1) + eta^2*g1./g0./(1-g1./g0.*(g1<g0))).* (g1 < 1 & g0 > g1) ...
    + (eta^2 * 1./(g0.*(g0 ~= 1)-1)) .* (g0 > 1 & g1 >= 1) ...
    + 1e8*(g1 < 1 & g0 == g1) + 1e8*(g1 >= 1 & g0 == 1 & eta>0);


figure('Position',[200,500,500,700],'WindowStyle','docked');
hold on
imagesc(g0, g1, genErrTh');
contour(g0, g1, genErrTh', 0:0.5:5, 'LineColor','k','LineWidth', 2);

axis('xy','square');
clim([0 5]);
colormap(cmp);
xlabel('1/\alpha_0');
ylabel('\alpha_1/\alpha_0');
cbar = colorbar;
ylabel(cbar, '\epsilon');
title(sprintf('L=1, unstructured, \\eta = %0.2f', eta));
set(gca, 'FontSize', 16, 'LineWidth', 2, 'Box','off','tickdir','out');

plot(0:0.01:1, 0:0.01:1, 'Color', bcolor,'linewidth', 2);
plot(1:0.01:2, ones(length(1:0.01:2)),  'Color', bcolor,'linewidth', 2);
plot(ones(length(1:0.01:2)), 1:0.01:2,  'Color', bcolor,'linewidth', 2);

%% Plot phase diagram without label noise, with structure

% Label noise
eta = 0;

% Power law exponents (length L+1)
b0 = 1;
b1 = 1;

k0 = ((pi/(1+b0))/sin(pi/(1+b0)))^(1+b0);
k1 = ((pi/(1+b1))/sin(pi/(1+b1)))^(1+b1);

chi = @(z) ( k0 .* (z.^b0-1) + (2 + b0*(1-k0)).*(1-1./z) ) .* (z>1);

genErrTh = ((1 + b1 + 1./(g1./g0.*(g1>g0) - 1)) .* chi(1./g0) + eta^2 * (b0+b1+ 1./(g1./g0.*(g1>g0) - 1) + 1./(1./g0.*(g0<1)-1))) .* (g0 < min(1,g1))...
    + (1./(1-g1./g0.*(g1<g0)) .* chi(1./g1) + eta^2*g1./g0./(1-g1./g0.*(g1<g0))).* (g1 < 1 & g0 > g1) ...
    + (eta^2 * 1./(g0.*(g0 ~= 1)-1)) .* (g0 > 1 & g1 >= 1) ...
    + 1e8*(g1 < 1 & g0 == g1) + 1e8*(g1 >= 1 & g0 == 1 & eta>0);


figure('Position',[200,500,500,700],'WindowStyle','docked');
hold on
imagesc(g0, g1, genErrTh');
contour(g0, g1, genErrTh', 0:5:40, 'LineColor','k','LineWidth', 2);

axis('xy','square');
clim([0 40]);
colormap(cmp);
xlabel('1/\alpha_0');
ylabel('\alpha_1/\alpha_0');
cbar = colorbar;
ylabel(cbar, '\epsilon');
title(sprintf('L=1,  \\gamma_{0} = %0.2f, \\gamma_{1} = %0.2f, \\eta = %0.2f', b0, b1,eta));
set(gca, 'FontSize', 16, 'LineWidth', 2, 'Box','off','tickdir','out');

plot(0:0.01:1, 0:0.01:1, 'Color', bcolor,'linewidth', 2);
plot(1:0.01:2, ones(length(1:0.01:2)),  'Color', bcolor,'linewidth', 2);
plot(ones(length(1:0.01:2)), 1:0.01:2,  'Color', bcolor,'linewidth', 2);

%% Plot phase diagram with label noise, with structure

% Label noise
eta = 0.5;

% Power law exponents (length L+1)
b0 = 1;
b1 = 1;

k0 = ((pi/(1+b0))/sin(pi/(1+b0)))^(1+b0);
k1 = ((pi/(1+b1))/sin(pi/(1+b1)))^(1+b1);

chi = @(z) ( k0 .* (z.^b0-1) + (2 + b0*(1-k0)).*(1-1./z) ) .* (z>1);

genErrTh = ((1 + b1 + 1./(g1./g0.*(g1>g0) - 1)) .* chi(1./g0) + eta^2 * (b0+b1+ 1./(g1./g0.*(g1>g0) - 1) + 1./(1./g0.*(g0<1)-1))) .* (g0 < min(1,g1))...
    + (1./(1-g1./g0.*(g1<g0)) .* chi(1./g1) + eta^2*g1./g0./(1-g1./g0.*(g1<g0))).* (g1 < 1 & g0 > g1) ...
    + (eta^2 * 1./(g0.*(g0 ~= 1)-1)) .* (g0 > 1 & g1 >= 1) ...
    + 1e8*(g1 < 1 & g0 == g1) + 1e8*(g1 >= 1 & g0 == 1 & eta>0);


figure('Position',[200,500,500,700],'WindowStyle','docked');
hold on
imagesc(g0, g1, genErrTh');
contour(g0, g1, genErrTh', 0:5:40, 'LineColor','k','LineWidth', 2);

axis('xy','square');
clim([0 40]);
colormap(cmp);
xlabel('1/\alpha_0');
ylabel('\alpha_1/\alpha_0');
cbar = colorbar;
ylabel(cbar, '\epsilon');
title(sprintf('L=1,  \\gamma_{0} = %0.2f, \\gamma_{1} = %0.2f, \\eta = %0.2f', b0, b1,eta));
set(gca, 'FontSize', 16, 'LineWidth', 2, 'Box','off','tickdir','out');

plot(0:0.01:1, 0:0.01:1, 'Color', bcolor,'linewidth', 2);
plot(1:0.01:2, ones(length(1:0.01:2)),  'Color', bcolor,'linewidth', 2);
plot(ones(length(1:0.01:2)), 1:0.01:2,  'Color', bcolor,'linewidth', 2);