# RECON Core Scripts

This repository contains the core scripts used in our paper submission.  
RECON builds on the open-source **LightRAG** library.

---

## Repository Structure

```

_RECON_core_scripts/
├── 1_recon_core_scripts/                           # Core RECON modules
│   ├── 1_intra_page_reflection.py                  # Intra-page entity extraction and reflection
│   ├── 2_inter_page_connection.py                  # Inter-page entity connection
│   └── _prompts.py                                 # Prompts used for MLLM-based extraction
│            
├── 2_qfvds_construction_scripts/                   # Scripts for building the QFVDS dataset
│   ├── 1_extract_keypoints.py                      # Extract atomic facts from documents
│   ├── 2_fact_clustering.py                        # Cluster facts into topics
│   ├── 3_topics_sampling.py                        # Sample topics at different scales
│   └── 4_qfvds_generator.py                        # Generate QA pairs with MLLM
│
├── 3_evaluation_scripts/                           # Evaluation utilities
│   ├── 1_compute_accuracy.py                       # Compute QA accuracy
│   ├── 2_compute_pairwise_comparison.py            # Pairwise comparison of answers
│   └── 3_calculate_pairwise_comparison_results.py
│
└── README.md

```

---

## Usage Notes

- RECON core functions rely on **MLLM API calls** (Openai API) and the **LightRAG** graph library.  

### Evaluation Scripts

1. **Accuracy Evaluation**  
   Run `1_compute_accuracy.py` to compute accuracy for generated answers.

2. **Pairwise Comparison Evaluation**  
   - Use `2_compute_pairwise_comparison.py` to create **batch API calls** for pairwise answer comparison.  
   - After completion, download the results from the OPENAI dashboard.

3. **Scoring**  
   - Feed the downloaded results into `3_calculate_pairwise_comparison_results.py`.  
   - This script computes the final pairwise comparison scores.
