import json

# This evaluation process eliminates positional bias
def calculate_win_rates(jsonl_file , swap_jsonl_file):
    criteria = ["SemanticSimilarity", "Faithfulness"]
    winner_counts = {"Answer 1": {criterion: 0 for criterion in criteria},
                    "Answer 2": {criterion: 0 for criterion in criteria},
                    "Tie": {criterion: 0 for criterion in criteria},
                    "total": 0}

    with open(jsonl_file, 'r', encoding='utf-8') as file:
        with open(swap_jsonl_file, 'r', encoding='utf-8') as swap_file:
            for line , swap_line in zip(file , swap_file):
                data = json.loads(line)
                swap_data = json.loads(swap_line)
                if "response" in data and "body" in data["response"]:
                    body = data["response"]["body"]
                    swap_body = swap_data["response"]["body"]
                    if "choices" in body and len(body["choices"]) and "choices" in swap_body and len(swap_body["choices"])> 0:
                        content = body["choices"][0]["message"]["content"]
                        swap_content = swap_body["choices"][0]["message"]["content"]
                        try:
                            if content.startswith("```json") and content.endswith("```"):
                                content = content[7:-3].strip()
                            
                            if swap_content.startswith("```json") and swap_content.endswith("```"):
                                swap_content = swap_content[7:-3].strip()
                            
                            result = json.loads(content)
                            swap_result = json.loads(swap_content)
                            for criterion in criteria:
                                if result[criterion]["Winner"] != swap_result[criterion]["Winner"]:
                                    winner = result[criterion]["Winner"]
                                else:
                                    winner = "Tie"
                                winner_counts[winner][criterion] += 1
                                winner_counts["total"] += 1
                        except json.JSONDecodeError as e:
                            print(f"Error decoding content: {e}\nContent: {content}")
                        except KeyError as e:
                            print(f"Missing key in content: {e}")

    win_rates = {}
    for criterion in criteria:
        total_criteria = winner_counts["Answer 1"][criterion] + winner_counts["Answer 2"][criterion] + winner_counts["Tie"][criterion]
        print(total_criteria)
        if total_criteria > 0:
            win_rates[criterion] = {
                "Answer 1": winner_counts["Answer 1"][criterion] / total_criteria * 100,
                "Answer 2": winner_counts["Answer 2"][criterion] / total_criteria * 100,
                "Tie": winner_counts["Tie"][criterion] / total_criteria * 100,
            }
        else:
            win_rates[criterion] = {"Answer 1": 0, "Answer 2": 0}

    return win_rates
