#!/bin/bash
#SBATCH -p gpu20
#SBATCH -t 20:00:00
#SBATCH -o supsup_pool_asc_qa-%j.out
#SBATCH --gres gpu:4

export HF_DATASETS_CACHE='./dataset_cache'
export TRANSFORMERS_CACHE='./model_cache'
#export TRANSFORMERS_OFFLINE=1


seed=(2021 111 222 333 444 555 666 777 888 999)

for round in 0;
do
  for idrandom in 0 1 2 3 4;
  do
    for ft_task in $(seq 2 18);
      do
        python -m torch.distributed.launch --nproc_per_node 4 --use_env finetune.py \
        --ft_task ${ft_task} \
        --idrandom ${idrandom} \
        --ntasks 19 \
        --baseline 'supsup_pool_adapter_ggg_asc_ce' \
        --seed ${seed[$round]} \
        --per_device_eval_batch_size 32 \
        --sequence_file 'asc_seq' \
        --per_device_train_batch_size 32 \
        --base_model_name_or_path 'facebook/bart-large' \
        --warmup_ratio 0.5 \
        --patient 50 \
        --fp16 \
        --max_source_length 128 \
        --pad_to_max_length \
        --adapter_lr 0.1 \
        --base_dir './data'
    done
  done
done


for round in 0;
do
  for idrandom in 1 2 3 4;
  do
    for ft_task in $(seq 0 18);
      do
        python -m torch.distributed.launch --nproc_per_node 4 --use_env finetune.py \
        --ft_task ${ft_task} \
        --idrandom ${idrandom} \
        --ntasks 19 \
        --baseline 'supsup_pool_adapter_ggg_asc_ce' \
        --seed ${seed[$round]} \
        --per_device_eval_batch_size 32 \
        --sequence_file 'asc_seq' \
        --per_device_train_batch_size 32 \
        --base_model_name_or_path 'facebook/bart-large' \
        --warmup_ratio 0.5 \
        --patient 50 \
        --fp16 \
        --max_source_length 128 \
        --pad_to_max_length \
        --adapter_lr 0.1 \
        --base_dir './data'
    done
  done
done
