#!/bin/bash
#SBATCH -p gpu20
#SBATCH -t 15:00:00
#SBATCH -o supsup_pool_dialogue_qa-%j.out
#SBATCH --gres gpu:4

export HF_DATASETS_CACHE='./dataset_cache'
export TRANSFORMERS_CACHE='./model_cache'
#export TRANSFORMERS_OFFLINE=1


seed=(2021 111 222 333 444 555 666 777 888 999)

for round in 0;
do
  for idrandom in 1 2 3 4;
  do
    for ft_task in $(seq 0 4);
      do
        python -m torch.distributed.launch --nproc_per_node 4 --use_env finetune.py \
        --ft_task ${ft_task} \
        --idrandom ${idrandom} \
        --ntasks 5 \
        --baseline 'supsup_pool_adapter_ggg_dialogue_ce' \
        --seed ${seed[$round]} \
        --num_beams 4 \
        --per_device_eval_batch_size 32 \
        --val_max_target_length 200 \
        --val_min_target_length 30 \
        --no_repeat_ngram_size 3 \
        --sequence_file 'dialogue_moz_seq' \
        --per_device_train_batch_size 16 \
        --base_model_name_or_path 'facebook/bart-large' \
        --warmup_ratio 0.5 \
        --patient 50 \
        --num_train_epochs 50 \
        --pad_to_max_length \
        --max_source_length 128 \
        --fp16\
        --adapter_lr 5e-2 \
        --base_dir './data'
    done
  done
done


