# CaDrift
## Requirements

Install dependencies with:

```bash
pip install -r requirements.txt
```

## Usage

To generate a dataset:

```bash
python RandomSCMGenerator.py
```

This will generate a random SCM with 25 features and 5 root nodes and generate data samples with it.

You can modify parameters such as number of features, drift points, and drift types in `RandomSCMGenerator.py`.

## Project Structure

- `SCM/`: Core modules for causal graph, mappers, and target functions.
- `statistics/`: Scripts for statistical analysis and plotting.
- `RandomSCMGenerator.py`: Main script for generating data and graphs.

## Example Analysis

You can use the scripts in `statistics/` to analyze the generated data, e.g.:

```bash
python statistics/lb.py
python statistics/plt_acf.py
```