import pandas as pd
from statsmodels.stats.diagnostic import acorr_ljungbox

def ljung_box_test_from_csv(csv_path: str, lags: int = 20, alpha: float = 0.05):
    df = pd.read_csv(csv_path)

    for col in df.columns:
        if df[col].dtype == 'object' or pd.api.types.is_categorical_dtype(df[col]):
            df[col] = df[col].astype('category').cat.codes

    results = []

    for col in df.columns:
        series = df[col].dropna().values
        test = acorr_ljungbox(series, lags=lags, return_df=True)
        pval = test['lb_pvalue'].values[-1]
        is_dependent = pval < alpha
        results.append({
            'Feature': col,
            'p-value': pval,
            'Reject H0 (i.i.d.)': is_dependent
        })

    return pd.DataFrame(results)


results = ljung_box_test_from_csv("../data_sample.csv", lags=20)
print(results)
