# AdaMoLE: Adaptive Mixture of Low-Rank Adaptation Experts

## Introduction

Discover AdaMoLE, an innovative model that synergizes the Mixture of Experts (MoE) framework with Low-Rank Adaptation (LoRA) for the fine-tuning of Large Language Models (LLMs). AdaMoLE transcends traditional static top-k expert activation methods by employing a dynamic thresholding mechanism, which adeptly adjusts to the complexity of various tasks, optimizing model performance across a range of language processing challenges.

## Features

- **Dynamic Expert Activation:** AdaMoLE revolutionizes expert activation with a dynamic threshold network, adapting to task complexities for optimal expert engagement.
- **Integration of LoRA and MoE:** Seamlessly combines Low-Rank Adaptation with the Mixture of Experts framework, enhancing the fine-tuning process for LLMs.
- **Hugging Face Compatibility:** Designed to be compatible with the Hugging Face's Transformers and Parameter-Efficient Fine-Tuning (PEFT) library, ensuring ease of use and integration into existing workflows.

## Installation

```bash
# Navigate to the AdaMoLE directory
cd AdaMoLE

# Install required dependencies
pip install -r requirements.txt
```

## Usage

```bash
# Train the model
python train.py @configs/llama_adamole_csr_train.config

# Test the model
python test.py @configs/llama_adamole_csr_test.config
```

## License

This project is licensed under the MIT License. See the [LICENSE](LICENSE) file for details.
