from Bio import SeqIO
import sys
import os 
import csv
import torch
import numpy as np

FOLDER = sys.argv[1]
OUTPUT_FILE = sys.argv[2]

folders = os.listdir(FOLDER)
all_pvalues=[]
total_subfolders=0

score=[]
for i in range(2, 11):
    score = score +[i]
output = open(OUTPUT_FILE, "w")
output.write(str(score)+"\n")

all_scores = torch.empty(0,9)

for subfolders in folders:
    read_tsv = csv.reader(open(FOLDER + subfolders+'/tomtom.tsv'), delimiter = "\t")
    i=0
    for row in read_tsv:
        if i==1:
            try:
                all_pvalues = all_pvalues +[float(row[3])]
            except:
                print("This subfolder failed: " + subfolders)
            break
        else: 
            i=i+1 

ordo = []
for i in range(2, 11):
    ordo = ordo + [sum(k < (10**(-i)) for k in all_pvalues)/len(all_pvalues)*100]
all_scores = torch.cat((all_scores, torch.from_numpy(np.array(ordo)).view(1,-1).float()), dim=0)
output.write(str(ordo)+"\n")

output.close()
torch.save(all_scores, OUTPUT_FILE[:-4] + "_torch_tensor.pt")
