#!/bin/bash

#SBATCH --time=03:00:00
#SBATCH --mem-per-cpu=20G
#SBATCH --cpus-per-task=2
DATASET_LOCATION=$1
RESULTS_LOCATION=$2

mkdir -p $RESULTS_LOCATION/raw_analysis
for f in $DATASET_LOCATION/40_ENCODE_TF_FILES_FASTA_POS/*;do
streme --p $f --n ${f/POS/NEG} --o $RESULTS_LOCATION/raw_analysis/${f##*/} --minw 8 --maxw 12 --nmotifs 5 --kmer 3 -hofract 0 --order 2
done
mkdir $RESULTS_LOCATION/tomtom_results
for f in $RESULTS_LOCATION/raw_analysis/*;do
g=${f##*/}
tomtom -thresh 1 -o $RESULTS_LOCATION/tomtom_results/${f##*/} $f/streme.xml inputs/motif_databases/EUKARYOTE/motif_${g::-6}
done
python scripts/tomtom_analysis.py $RESULTS_LOCATION/tomtom_results/ $RESULTS_LOCATION/STREME_ANALYSIS.txt
