This is the pytorch implementation of SEISM: SElective Inference for Sequence Motifs

> Anonymous authors

### To be installed in a virtual environment:

```bash
pip install .
python install_dsk.py
python -m test.total_test
```

### For Documentation
```bash
seism -h
seism simulation -h
seism analysis -h
```
### To check statistical validity (calibration)

A pvalue under the null hypothesis can be generated with the following command line
```bash
seism simulation output_directory --hr-nb-burn-in 10000 --hr-nb-replicates 50000 --nb-samples 30 --hr-mesh-size 0.5 
```

### Exemple analysis

```bash
seism analysis test/test_files/50_seq_file.fasta analysis_test --hr-nb-burn-in 10000 --hr-nb-replicates 50000 --number-of-threads 2
```
