#!/bin/bash

#SBATCH --time=03:00:00
#SBATCH --mem-per-cpu=20G
#SBATCH --cpus-per-task=2

DATASET_LOCATION=$1
RESULTS_LOCATION=$2

mkdir -p $RESULTS_LOCATION/raw_analysis
cd ../CKN-seq
for f in ../selection_performances/${DATASET_LOCATION:0:-1}/40_ENCODE_TF_FILES_FASTA_COMBINED/*;do
python -m ckn.cli train_supervised --splitted $f 0.25 --nb-motifs 128 --motif-size 10 --nb-epochs 150 --label-type bool ../selection_performances/$RESULTS_LOCATION/raw_analysis/${f##*/}	
done
mkdir ../selection_performances/$RESULTS_LOCATION/motifs/
for f in ../selection_performances/$RESULTS_LOCATION/raw_analysis/*;do
python -m ckn.cli motif $f --ppm ../selection_performances/$RESULTS_LOCATION/motifs/${f##*/}
done
mkdir ../selection_performances/$RESULTS_LOCATION/raw_analysis_meme_format/
cd ../selection_performances
for f in $RESULTS_LOCATION/motifs/*;
do
python scripts/ckn_results_to_meme_format.py $f $RESULTS_LOCATION/raw_analysis_meme_format/${f##*/} 10;
done
mkdir $RESULTS_LOCATION/tomtom_results
for f in $RESULTS_LOCATION/raw_analysis_meme_format/*;do
echo $f
g=${f##*/}
tomtom -thresh 1 -o $RESULTS_LOCATION/tomtom_results/${f##*/} $f inputs/motif_databases/EUKARYOTE/motif_${g::-6}
done
python scripts/tomtom_analysis.py $RESULTS_LOCATION/tomtom_results/ $RESULTS_LOCATION/CKN_ANALYSIS.txt

