from Bio import SeqIO
import sys
import os 

sp = sys.argv[1]
out = sys.argv[2]

lst=os.listdir(sp)

genome = "inputs/K562_files/hg19.fasta"
genome_dict = SeqIO.to_dict(SeqIO.parse(open(genome, "rt"), "fasta"))



# Extract sequences

for files in lst:
    with open(sp + files, "r") as f1:  
        output_seq = open(out + files +".fasta", "w")
        for i in f1.readlines()[1:]:
            i = i.split("\t")
            chrom = i[0]
            start = int(i[1])
            end = int(i[2])

            mean = (start+end)//2

            start = mean - 50
            end = mean + 50

            if chrom in genome_dict.keys():
                seq = genome_dict[chrom]
                cut_sequence = seq[start:end].upper()

                cut_sequence.id = str(i[3])
                cut_sequence.description = "1"

                SeqIO.write(cut_sequence, output_seq, "fasta-2line")

    output_seq.close()


