#!/usr/bin/env python3
# coding=utf-8

from Bio import SeqIO
import sys
import os 
import torch
import numpy as np
import math
import time

ckn = sys.argv[1]
res = sys.argv[2]
length = int(sys.argv[3])


ckn_file = open(ckn, 'r')


nb_lines=0
for q in ckn_file:
    nb_lines+=1

ckn_file.close()
ckn_file = open(ckn, 'r')

def compute_shannons_entropy(filter):
    epsilon = 1e-5
    filter_b = filter.view(-1)
    entropy=0
    for a in range (filter_b.size()[0]):
        entropy+=-filter_b[a] * math.log(filter_b[a]+epsilon, 2)
    return(entropy)

all_motifs = torch.empty(0,4,length)
j=0


motif = torch.zeros(1,4,length)
new_motif = torch.zeros(1,4,length)
best_motif = torch.zeros(1,4,length)
all_motifs = torch.empty(0,4,length)

for l in ckn_file:
    if j==0:
        best_entropy = math.inf

    elif (j%(length+2)==0):
        all_motifs = torch.cat((all_motifs, new_motif), dim=0)
        motif = new_motif.clone().detach()
        if (compute_shannons_entropy(motif)<best_entropy):
            best_entropy = compute_shannons_entropy(motif)
            best_motif = motif.clone().detach()

        new_motif = torch.zeros(1,4,length)

    elif (j%(length+2)==1):
        pass
    else:
        new_motif[0,:,(j%(length+2))-2] = torch.from_numpy(np.array([float(h) for h in l.split('\t')]))
    j+=1

all_motifs = torch.cat((all_motifs, new_motif), dim=0)
motif = new_motif.clone().detach()
if (compute_shannons_entropy(motif)<best_entropy):
    best_entropy = compute_shannons_entropy(motif)
    best_motif = motif.clone().detach()
ckn_file.close()

ckn_file = open(ckn, 'r')


meme_format_file = open(res, 'w')


meme_format_file.write("MEME version 5.3.0 \n")
meme_format_file.write("\n")
meme_format_file.write("ALPHABET= ACGT \n")
meme_format_file.write("\n")
meme_format_file.write("strands: + -\n")
meme_format_file.write("\n")
meme_format_file.write("Background letter frequencies \n")
meme_format_file.write("A 0.25 C 0.25 G 0.25 T 0.25 \n")
meme_format_file.write("\n")

for j in range(all_motifs.size()[0]//2):
    meme_format_file.write("\n")
    motif = all_motifs[j,:,:].unsqueeze(0)
    meme_format_file.write("MOTIF "+str(j)+" \n")
    meme_format_file.write("letter-probability matrix: alength= 4 w= "+str(motif.size()[2])+" nsites= 20 E= 0 \n")
    for i in range (motif.size()[2]):
        meme_format_file.write(str("%.3f" % float(motif[0,0,i])))
        meme_format_file.write("\t")
        meme_format_file.write(str("%.3f" % float(motif[0,1,i])))
        meme_format_file.write("\t")
        meme_format_file.write(str("%.3f" % float(motif[0,2,i])))
        meme_format_file.write("\t")
        meme_format_file.write(str("%.3f" % float(motif[0,3,i])))
        meme_format_file.write("\n")


# meme_format_file.write("MOTIF 1 \n")
# meme_format_file.write("letter-probability matrix: alength= 4 w= "+str(length)+" nsites= 20 E= 0 \n")
# for i in range (length):
#     meme_format_file.write(str(round(float(best_motif[0,0,i]),3))+str("\t"))
#     meme_format_file.write(str(round(float(best_motif[0,1,i]),3))+str("\t"))
#     meme_format_file.write(str(round(float(best_motif[0,2,i]),3))+str("\t"))
#     meme_format_file.write(str(round(float(best_motif[0,3,i]),3))+str("\n"))
# meme_format_file.close()




