from Bio import SeqIO
import sys
import os 
import torch

seism = sys.argv[1]
res = sys.argv[2]
n_motifs = int(sys.argv[3])
files = os.listdir(seism)

for f in files:
    meme_format_file = open(res+f, 'w')
    meme_format_file.write("MEME version 5.3.0 \n")
    meme_format_file.write("\n")
    meme_format_file.write("ALPHABET= ACGT \n")
    meme_format_file.write("\n")
    meme_format_file.write("strands: + -\n")
    meme_format_file.write("\n")
    meme_format_file.write("Background letter frequencies \n")
    meme_format_file.write("A 0.25 C 0.25 G 0.25 T 0.25 \n")
    
    
    for j in range(n_motifs):
        meme_format_file.write("\n")
        motif = torch.load(seism+f+'/motif_'+str(j)+'.pt')
        meme_format_file.write("MOTIF "+str(j)+" \n")
        meme_format_file.write("letter-probability matrix: alength= 4 w= "+str(motif.size()[2])+" nsites= 20 E= 0 \n")
        for i in range (motif.size()[2]):
            meme_format_file.write(str("%.3f" % float(motif[0,0,i])))
            meme_format_file.write("\t")
            meme_format_file.write(str("%.3f" % float(motif[0,1,i])))
            meme_format_file.write("\t")
            meme_format_file.write(str("%.3f" % float(motif[0,2,i])))
            meme_format_file.write("\t")
            meme_format_file.write(str("%.3f" % float(motif[0,3,i])))
            meme_format_file.write("\n")
        
    meme_format_file.close()





