#!/bin/bash

#SBATCH --time=05:00:00
#SBATCH --mem-per-cpu=20G
#SBATCH --cpus-per-task=2

DATASET_LOCATION=$1
RESULTS_LOCATION=$2

mkdir -p $RESULTS_LOCATION/raw_analysis
for f in ${DATASET_LOCATION:0:-1}/40_ENCODE_TF_FILES_FASTA_COMBINED/*;do
echo $f;
echo selection_performances/$RESULTS_LOCATION/raw_analysis/${f##*/};
seism analysis $f $RESULTS_LOCATION/raw_analysis/${f##*/} \
--nb-motifs 5 --min-motifs-length 8 --max-motifs-length 12 --do-not-perform-inference \
--ridge-lambda 1e-2;
done
mkdir $RESULTS_LOCATION/raw_analysis_meme_format
python scripts/seism_results_to_meme_format.py $RESULTS_LOCATION/raw_analysis/ $RESULTS_LOCATION/raw_analysis_meme_format/ 5
mkdir $RESULTS_LOCATION/tomtom_results
for f in $RESULTS_LOCATION/raw_analysis_meme_format/*;do
g=${f##*/}
tomtom -thresh 1 -o $RESULTS_LOCATION/tomtom_results/${f##*/} $f inputs/motif_databases/EUKARYOTE/motif_${g::-6}
done
python scripts/tomtom_analysis.py $RESULTS_LOCATION/tomtom_results/ $RESULTS_LOCATION/SEISM_ANALYSIS.txt

