import os
from openai import OpenAI
import requests
import uuid


os.environ["API_KEY"] = "xx"
os.environ["BASE_URL"] = "xx"

def  request_api(messages, model='deepseek-v3-250324', top_p=0.7, temperature=0.7):
    client = OpenAI(
        api_key=os.environ.get("API_KEY"),
        base_url=os.environ.get("BASE_URL"),
    )
    max_retries = 3
    for attempt in range(max_retries):
        try:
            completion = client.chat.completions.create(
                model=model,
                messages=messages,
                top_p=top_p,
                temperature=temperature,
                max_tokens=128
            )
            return completion.choices[0].message
        except Exception as e:
            if attempt == max_retries - 1:
                raise e
            continue
def  request_api_notopp(messages, model='deepseek-v3-250324', temperature=0.7):
    client = OpenAI(
        api_key=os.environ.get("API_KEY"),
        base_url=os.environ.get("BASE_URL"),
    )
    max_retries = 3
    for attempt in range(max_retries):
        try:
            completion = client.chat.completions.create(
                model=model,
                messages=messages,
                temperature=temperature
            )
            return completion.choices[0].message
        except Exception as e:
            if attempt == max_retries - 1:
                raise e
            continue
        
def request_doubao(messages, top_p=0.7, temperature=0.7):
    client = OpenAI(
        api_key="xx",
        base_url="xx",
    )
    max_retries = 3
    for attempt in range(max_retries):
        try:
            completion = client.chat.completions.create(
                model="doubao-seed-1-6-250615",
                # model="doubao-1-5-pro-32k-character-250715",
                messages=messages,
                top_p=top_p,
                temperature=temperature,
                extra_body={
                    "thinking": {
                        "type": "disabled"  # 不使用深度思考能力
                    }
                }
            )
            return completion.choices[0].message
        except Exception as e:
            if attempt == max_retries - 1:
                raise e
            continue

# Example usage:
# messages = [{"role": "user", "content": "你好"}]
# model = "deepseek-v3-250324"
# result = call_model_api(messages, model, top_k=50, top_p=0.9, temperature=0.7)
# print(result)
def request_by_model(model, messages):
    """
    请求NPC接口
    """
    # 端口IDC用 81、Dev用 1081、本地用8080
    # url = "xx"
    url = "xx"

    headers = {
        "Content-Type": "application/json",
        "Authorization": "Bearer xx",
        "Wsid" : "xx"
    }
    # [
    #         {"role": "system", "content": ""},
    #         {"role": "user", "content": "我现在应该种什么菜？"}
    #     ]
    data = {
        "messages": messages,
        "model" : model,
        "query_id": "test_query_id_" + str(uuid.uuid4()),
        "stream": False,
        "output_seq_len": 2048,
        "decoupled": 0,
        "top_p": 0.7,
        "temperature": 0.7
        }

   
    resp = requests.post(url, headers=headers, json=data)
    # print(resp.text)
    res = resp.json()
    # print(res)
    return res['choices'][0]['message']['content']

if __name__ == "__main__":
    m = [{"role": "system", "content": ""},{"role": "user", "content": "你是谁"},{"role": "assistant", "content": "我叫[NPC_NAME]"},{"role": "user", "content": "那么问题来了"}]
    model = "deepseek-v3-250324"
    # model = "deepseek-r1-250528"
    # result = request_doubao(messages, model)
    result = request_by_model(model='qwen_72bbb',messages=m)
    print(result)
