import pandas as pd
import os
def anonymization(file):
    df = pd.read_json(file,lines=True)
    if "npc_persona" in df.columns:
        df.drop(columns=["npc_persona"], inplace=True)
    if "persona_str" in df.columns:
        df.drop(columns=["persona_str"], inplace=True)
    if "domain_str" in df.columns:
        df.drop(columns=["domain_str"], inplace=True)
    if "topic_str" in df.columns:
        df.drop(columns=["topic_str"], inplace=True)
    if "intra_score" in df.columns:
        df.drop(columns=["intra_score"], inplace=True)
    if "rewrite_query" in df.columns:
        df.drop(columns=["rewrite_query"], inplace=True)
    if "original_query" in df.columns:
        df.drop(columns=["original_query"], inplace=True)
    # df.drop(columns=["persona_str",'domain_str','topic_str'], inplace=True)
    for i, row in df.iterrows():
        if row["multi_type"] == "knowledge":
            # anonymization
            df.loc[i, "domain"] = "[anonymous]"
            df.loc[i, "topic"] = "[anonymous]"
            df.loc[i, "context"] = "[anonymous]"
            if 'explanation' in row:
                df.loc[i, "explanation"] = "[anonymous]"
            if 'intents_list' in row:
                df.loc[i, "intents_list"] = "[anonymous]"
    # save = file.split(".")[0] + "_processed.jsonl"
    df.to_json(file, orient="records", lines=True, force_ascii=False)
    print("Done!")
    
if __name__ == "__main__":
    # dir = '/data/workspace/fake-player-aaai/baselines/vanilla-fewshot/r1_saves'
    # for file in os.listdir(dir):
    #     if file.endswith(".jsonl"):
    #         anonymization(os.path.join(dir, file))
    # dir = '/data/workspace/fake-player-aaai/baselines/vanilla-fewshot/v3_saves'
    # for file in os.listdir(dir):
    #     if file.endswith(".jsonl"):
    #         anonymization(os.path.join(dir, file))
    # dir = '/data/workspace/fake-player-aaai/baselines/vanilla-rpa/r1_saves'
    # for file in os.listdir(dir):
    #     if file.endswith(".jsonl"):
    #         anonymization(os.path.join(dir, file))
    # dir = '/data/workspace/fake-player-aaai/baselines/vanilla-rpa/v3_saves'
    # for file in os.listdir(dir):
    #     if file.endswith(".jsonl"):
    #         anonymization(os.path.join(dir, file))
    # dir = '/data/workspace/fake-player-aaai/fake_player/v3_saves'
    # for file in os.listdir(dir):
    #     if file.endswith(".jsonl"):
    #         anonymization(os.path.join(dir, file))
    # dir = '/data/workspace/fake-player-aaai/fake_player/r1_saves'
    # dir = '/data/workspace/fake-player-iclr/baselines/rpa/doubao_saves'
    # dir = '/data/workspace/fake-player-iclr/baselines/icl/doubao_saves'
    dir = '/data/workspace/fake-player-iclr/fake-player/doubao'
    for file in os.listdir(dir):
        if file.endswith(".jsonl"):
            anonymization(os.path.join(dir, file))