import os
from openai import OpenAI
os.environ["API_KEY"] = "API_KEY"
os.environ["BASE_URL"] = "BASE_URL"
def  request_api(messages, model='deepseek-v3-250324', top_p=0.7, temperature=0.7):
    client = OpenAI(
        api_key=os.environ.get("API_KEY"),
        base_url=os.environ.get("BASE_URL"),
    )
    max_retries = 3
    for attempt in range(max_retries):
        try:
            completion = client.chat.completions.create(
                model=model,
                messages=messages,
                top_p=top_p,
                temperature=temperature
            )
            return completion.choices[0].message
        except Exception as e:
            if attempt == max_retries - 1:
                raise e
            continue
def  request_api_notopp(messages, model='deepseek-v3-250324', temperature=0.7):
    client = OpenAI(
        api_key=os.environ.get("API_KEY"),
        base_url=os.environ.get("BASE_URL"),
    )
    max_retries = 3
    for attempt in range(max_retries):
        try:
            completion = client.chat.completions.create(
                model=model,
                messages=messages,
                temperature=temperature
            )
            return completion.choices[0].message
        except Exception as e:
            if attempt == max_retries - 1:
                raise e
            continue
        
def request_api_batch(messages, model='deepseek-v3-250324', top_p=0.7, temperature=0.7):
    from volcenginesdkarkruntime import Ark
    client = Ark(
        api_key=os.environ.get("API_KEY"),
        base_url=os.environ.get("BASE_URL"),
    )
    max_retries = 3
    for attempt in range(max_retries):
        try:
            completion = client.batch_chat.completions.create(
                model=model,
                messages=messages,
                top_p=top_p,
                temperature=temperature
            )
            return completion.choices[0].message
        except Exception as e:
            if attempt == max_retries - 1:
                raise e
            continue



if __name__ == "__main__":
    messages = [{"role": "user", "content": "你是谁"},{"role": "assistant", "content": "我叫[NPC_NAME]"},{"role": "assistant", "content": "那么问题来了"}, {"role": "user", "content": "什么问题"}]
    model = "deepseek-v3-250324"
    # model = "deepseek-r1-250528"
    result = request_api(messages, model)
    print(result)
