import sys
from .api import request_api,request_doubao, request_by_model

from json_repair import repair_json
import json



class Agent:
    """
    Agent类封装了LLM调用和prompt管理功能
    """
    def __init__(self, model='deepseek-v3-250324', meta_prompt=''):
        """
        初始化Agent
        :param model: 使用的LLM模型名称
        :param prompt_file: prompt模板文件路径
        """
        self.model = model
        self.meta_prompt = meta_prompt
        
        # initialize messages
        self.messages = [{"role": "system", "content": meta_prompt}]
        
    def get_messages(self):
        return self.messages
    
    def append_message(self, message):
        self.messages.append(message)
        
    def generate(self, messages):
        """
        调用LLM生成内容
        :param messages: 消息列表
        :return: 生成的文本内容
        """
        if 'doubao' in self.model:
            content = request_doubao(messages).content
        elif 'qwen' in self.model:
            content = request_by_model(model=self.model, messages=messages)
        else:
            content = request_api(messages, self.model).content
        # content = response.content
        content = content.replace('```', '').replace('json', '').replace('\n', '')
        return content
        
    
    def generate_json(self, messages,  **kwargs):
        """
        调用LLM生成内容，并解析返回指定字段
        :param kwargs: 要提取的字段名作为键，值为任意占位符
        :return: 包含指定字段的字典
        """
        for i in range(3):
            try:
                if 'doubao' in self.model:
                    content = request_doubao(messages).content
                elif 'qwen' in self.model:
                    content = request_by_model(model=self.model, messages=messages)
                else:
                    content = request_api(messages, self.model).content
                # content = response.content
                # self.append_message({"role": "assistant", "content": content})
                content = content.replace('```', '').replace('json', '').replace('\n', '')
                
                try:
                    # 尝试解析JSON
                    json_data = json.loads(content)
                except json.JSONDecodeError:
                    # 如果解析失败，尝试修复JSON
                    repaired_content = repair_json(content)
                    json_data = json.loads(repaired_content)

                # 提取指定字段
                result = {}
                for key in kwargs.keys():
                    if key in json_data:
                        result[key] = json_data[key]
                    else:
                        # 如果字段不存在，返回None
                        result[key] = None
                return result
            except Exception as e:
                print('generate_json error continue asking')
                print(f'error content: {content}')
        print('3times error')
        return 'none'
        
        
