import matplotlib.pyplot as plt
import numpy as np
from matplotlib.patches import Patch

times_hmc_1 = np.array([79.62,  43.43, 7.01, 26, 30.13, 8.63, 10.54, 112])
mean_hmc_1 = np.mean(times_hmc_1)
std_hmc_1 = np.std(times_hmc_1)
mean_hmc = np.array(5081.6) 


times_mb_1 = np.array([0.33, 0.34, 0.37, 0.34, 0.33, 0.35, 0.33, 0.34])
times_is_1 = np.array([0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02])
mean_mb_1 = np.mean(times_mb_1)
std_mb_1 = np.std(times_mb_1)
mean_mbp_1 = np.mean(times_mb_1 + times_is_1)
std_mbp_1 = np.std(times_mb_1 + times_is_1)

times_mb = np.array([9.07, 8.87, 9.13, 9.42, 8.84, 9.45, 9.11, 9.54])
times_is = np.array([0.5, 0.54, 0.5, 0.52, 0.51, 0.49, 0.5, 0.54])
mean_mb = np.mean(times_mb)
std_mb = np.std(times_mb)
mean_mbp = np.mean(times_mb + times_is)
std_mbp = np.std(times_mb + times_is)


# conditions = ['MB', 'MB+', 'HMC']
# values = [[ mean_mb_1, mean_mbp_1, mean_hmc_1], [mean_mb, mean_mbp, mean_hmc]]
# errors = [[std_mb_1, std_mbp_1, std_hmc_1], [std_mb, std_mbp, 0]]
# colors = ['mediumseagreen', 'darkseagreen',  'tan']
# labels = ['1', '128']

conditions = ['MB', 'HMC']
values = [[mean_mbp_1, mean_hmc_1], [mean_mbp, mean_hmc]]
errors = [[std_mbp_1, std_hmc_1], [std_mbp, 0]]
colors = ['green', 'goldenrod']
labels = ['1', '128']
x_pos = np.arange(len(conditions))
bar_width = 0.47  # width of each bar

fig, ax = plt.subplots(figsize=(6.5, 8), dpi=300)

# Plot bars for '1 dataset' with normal linewidth
bars1 = ax.bar(x_pos - bar_width/2, values[0], yerr=errors[0],
       width=bar_width, color=colors,
       edgecolor='black', linewidth=1.5, capsize=8,
       error_kw=dict(lw=1.5))

# Plot bars for '100 datasets' with thicker linewidth
bars2 = ax.bar(x_pos + bar_width/2, values[1], yerr=errors[1],
       width=bar_width, color=colors,
       edgecolor='black', linewidth=3.5, capsize=8,
       error_kw=dict(lw=1.5))

# add numbers on top
ax.bar_label(bars1, label_type='center', padding=-2, fontsize=16, color='w', fmt='{:,.1f}')
ax.bar_label(bars2, label_type='center', padding=-2, fontsize=16, color='w', fmt='{:,.1f}')

# Despine the plot
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)

ax.set_xticks(x_pos)
ax.set_xticklabels(conditions, fontsize=28)
ax.set_yscale('log')
ax.set_ylim(0, 10**4)
ax.tick_params(axis='y', labelsize=22)
ax.set_ylabel('sec', fontsize=28, labelpad=15)

# Create custom legend handles with different linewidths as indicators
legend_handles = [
    Patch(facecolor='lightgray', edgecolor='black', linewidth=1.5, label=labels[0]),
    Patch(facecolor='lightgray', edgecolor='black', linewidth=3.5, label=labels[1])
]
ax.legend(handles=legend_handles, fontsize=22, title='# datasets', title_fontsize=24)
# ax.set_title('Required Time', size=30, pad=30)
plt.tight_layout()
plt.show()
