function [softmaxv,a,aprob] = mySoftmax( q,tau )
	n = length(q);
    a = zeros(n,1);
    exp_q = exp(q./tau);
    
    % check if exp is too large
    inf_id = find(exp_q==Inf);
    if isempty(inf_id)~=1
        disp('exp_q too large error')
%         pause
%         exp_q(exp_q~=Inf) = 0;
%         exp_q(inf_id) = 1/length(inf_id);
        
    end
    
    % check if exp is too small
    zero_id = find(exp_q==0);
    if length(zero_id)==n
        disp('exp_q too small')
%         pause
        exp_q(zero_id) = 1/n;
    end
    
    v = exp_q./sum(exp_q);
    softmaxv = v'*q;
    
    a_pick = pick( v );
    a(a_pick) = 1;
    aprob  = v(a_pick);
    
    if sum(isnan(exp_q))>0 || sum(isnan(v))>0
        disp('error')
    end
end


