import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
import numpy as np
import random
import pandas as pd
import pickle
from multiprocessing import Pool, cpu_count
import tqdm
import warnings
import eventlet
from func_timeout import func_timeout
import networkx as nx
from matplotlib import pyplot as plt
import os
import sys
import copy
# np.seterr(all="warn")
# warnings.filterwarnings('error')
import warnings
from scipy.integrate import IntegrationWarning

# warnings.filterwarnings("ignore", category=IntegrationWarning)
warnings.filterwarnings("ignore", message="lsoda-- warning", category=UserWarning)
with warnings.catch_warnings():
    warnings.simplefilter("ignore")


def func1(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS = y
    dSdt = k12 * catS - k11 * S * cat
    dPdt = k21 * catS - k22 * cat * P
    dcatdt = ( k12 + k21 ) * catS - ( k11 * S + k22 * P ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * catS
    return [dSdt, dPdt, dcatdt, dcatSdt]

def func2(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, cat2 = y
    dSdt = k12 * catS - k11 * S * cat
    dPdt = k21 * catS - k22 * cat * P
    dcatdt = ( k12 + k21 ) * catS + 2 * k31 * cat2 - ( k11 * S + k22 * P + 2 * k32 * cat ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * catS
    dcat2dt = k32 * cat ** 2 - k31 * cat2
    return [dSdt, dPdt, dcatdt, dcatSdt, dcat2dt]

def func3(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, cat2, cat2S = y
    dSdt = k12 * cat2S - k11 * S * cat2
    dPdt = k21 * cat2S - k22 * cat2 * P
    dcatdt = 2 * k32 * cat2 - 2 * k31 * cat ** 2
    dcat2dt = ( k12 + k21 ) * cat2S + k31 * cat ** 2 - ( k11 * S + k22 * P + k32 ) * cat2
    dcat2Sdt = ( k11 * S + k22 * P ) * cat2 - ( k12 + k21 ) * cat2S
    return [dSdt, dPdt, dcatdt, dcat2dt, dcat2Sdt]

def func4(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, X = y
    dSdt = k12 * X * catS - k11 * S * cat
    dPdt = k21 * X * catS - k22 * cat * P
    dcatdt = ( k12 + k21 ) * X * catS - ( k11 * S + k22 * P ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * X * catS
    dXdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * X * catS
    return [dSdt, dPdt, dcatdt, dcatSdt, dXdt]

def func5(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, catP = y
    dSdt = k12 * catS - k11 * S * cat
    dPdt = k31 * catP - k32 * cat * P
    dcatdt = k12 * catS + k31 * catP - ( k11 * S + k32 * P ) * cat
    dcatSdt = ( k11 * S + k22 * catP ) * cat - ( k12 + k21 * cat ) * catS
    dcatPdt = k21 * catS * cat + k32 * P * cat - ( k31 + k22 * cat ) * catP
    return [dSdt, dPdt, dcatdt, dcatSdt, dcatPdt]

def func6(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catStar, catStarS = y
    dSdt = k12 * catStarS - k11 * S * catStar
    dPdt = k21 * catStarS - k22 * catStar * P
    dcatdt = - k31 * cat
    dcatStardt = k31 * cat + ( k12 + k21 ) * catStarS - ( k11 * S + k22 * P ) * catStar
    dcatStarSdt = ( k11 * S + k22 * P ) * catStar - ( k12 + k21 ) * catStarS
    return [dSdt, dPdt, dcatdt, dcatStardt, dcatStarSdt]

def func7(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, catS2 = y
    dSdt = k12 * catS2 - k11 * S * catS + k32 * catS - k31 * S * cat
    dPdt = k21 * catS2 - k22 * catS * P
    dcatdt = k32 * catS - k31 * S * cat
    dcatSdt = k31 * S * cat - k32 * catS + ( k12 + k21 ) * catS2 - ( k11 * S + k22 * P ) * catS
    dcatS2dt = ( k11 * S + k22 * P ) * catS - ( k12 + k21 ) * catS2
    return [dSdt, dPdt, dcatdt, dcatSdt, dcatS2dt]

def func8(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catStar, catStarS, L = y
    dSdt = k12 * catStarS - k11 * S * catStar
    dPdt = k21 * catStarS - k22 * catStar * P
    dcatdt = k32 * L * catStar - k31 * cat
    dcatStardt = k31 * cat - k32 * L * catStar + ( k12 + k21 ) * catStarS - ( k11 * S + k22 * P ) * catStar
    dcatStarSdt = ( k11 * S + k22 * P ) * catStar - ( k12 + k21 ) * catStarS
    dLdt = k31 * cat - k32 * L * catStar
    return [dSdt, dPdt, dcatdt, dcatStardt, dcatStarSdt, dLdt]

def func9(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, Incat = y
    dSdt = k12 * catS - k11 * S * cat
    dPdt = k21 * catS - k22 * cat * P
    dcatdt = ( k12 + k21 ) * catS - ( k11 * S + k22 * P + k32 ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21) * catS
    dIncatdt = k32 * cat
    return [dSdt, dPdt, dcatdt, dcatSdt, dIncatdt]

def func10(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, Inhbt, IncatI = y
    dSdt = k12 * catS - k11 * S * cat
    dPdt = k21 * catS - k22 * cat * P
    dcatdt = ( k12 + k21 ) * catS - ( k11 * S + k22 * P + k32 * Inhbt ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * catS
    dInhbtdt = - k32 * Inhbt * cat
    dIncatIdt = k32 * Inhbt * cat
    return [dSdt, dPdt, dcatdt, dcatSdt, dInhbtdt, dIncatIdt]

def func11(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, IncatS = y
    dSdt = k12 * catS - ( k11 + k32 ) * S * cat
    dPdt = k21 * catS - k22 * cat * P
    dcatdt = ( k12 + k21 ) * catS - ( k11 * S + k22 * P + k32 * S ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * catS
    dIncatSdt = k32 * S * cat
    return [dSdt, dPdt, dcatdt, dcatSdt, dIncatSdt]

def func12(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, IncatP = y
    dSdt = k12 * catS - k11 * S * cat
    dPdt = k21 * catS - ( k22 + k32 ) * cat * P
    dcatdt = ( k12 + k21 ) * catS - ( k11 * S + k22 * P + k32 * P ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * catS
    dIncatPdt = k32 * P * cat
    return [dSdt, dPdt, dcatdt, dcatSdt, dIncatPdt]

def func13(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, Incat2 = y
    dSdt = k12 * catS - k11 * S * cat
    dPdt = k21 * catS - k22 * cat * P
    dcatdt = ( k12 + k21 ) * catS - ( k11 * S + k22 * P + 2 * k32 * cat ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * catS
    dIncat2dt = k32 * cat ** 2
    return [dSdt, dPdt, dcatdt, dcatSdt, dIncat2dt]

def func14(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, IncatS = y
    dSdt = k12 * catS - k11 * S * cat
    dPdt = k21 * catS - k22 * cat * P
    dcatdt = ( k12 + k21 ) * catS - ( k11 * S + k22 * P ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k32 ) * catS
    dIncatSdt = k32 * catS
    return [dSdt, dPdt, dcatdt, dcatSdt, dIncatSdt]

def func15(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, Inhbt, IncatSI = y
    dSdt = k12 * catS - k11 * S * cat
    dPdt = k21 * catS - k22 * cat * P
    dcatdt = ( k12 + k21 ) * catS - ( k11 * S + k22 * P ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k32 * Inhbt ) * catS
    dInhbtdt = - k32 * Inhbt * catS
    dIncatSIdt = k32 * Inhbt * catS
    return [dSdt, dPdt, dcatdt, dcatSdt, dInhbtdt, dIncatSIdt]

def func16(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, IncatS2 = y
    dSdt = k12 * catS - k11 * S * cat - k32 * S * catS
    dPdt = k21 * catS - k22 * cat * P
    dcatdt = ( k12 + k21 ) * catS - ( k11 * S + k22 * P ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k32 * S ) * catS
    dIncatS2dt = k32 * S * catS
    return [dSdt, dPdt, dcatdt, dcatSdt, dIncatS2dt]

def func17(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, IncatSP = y
    dSdt = k12 * catS - k11 * S * cat
    dPdt = k21 * catS - k22 * cat * P - k32 * P * catS
    dcatdt = ( k12 + k21 ) * catS - ( k11 * S + k22 * P ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k32 * P ) * catS
    dIncatSPdt = k32 * P * catS
    return [dSdt, dPdt, dcatdt, dcatSdt, dIncatSPdt]

def func18(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, Incat2S2 = y
    dSdt = k12 * catS - k11 * S * cat
    dPdt = k21 * catS - k22 * cat * P
    dcatdt = ( k12 + k21 ) * catS - ( k11 * S + k22 * P ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k32 * catS ) * catS
    dIncat2S2dt = k32 * catS ** 2
    return [dSdt, dPdt, dcatdt, dcatSdt, dIncat2S2dt]

def func19(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, Incat2S = y
    dSdt = k12 * catS - k11 * S * cat
    dPdt = k21 * catS - k22 * cat * P
    dcatdt = ( k12 + k21 ) * catS - ( k11 * S + k22 * P + k32 * catS ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k32 * cat ) * catS
    dIncat2Sdt = k32 * cat * catS
    return [dSdt, dPdt, dcatdt, dcatSdt, dIncat2Sdt]

def func20(t, y, k11, k12, k21, k22, k31, k32, k41, k42):
    S, P, cat, catS, Incat, IncatS = y
    dSdt = k12 * catS - k11 * S * cat
    dPdt = k21 * catS - k22 * cat * P
    dcatdt = ( k12 + k21 ) * catS - ( k11 * S + k22 * P + k32 ) * cat
    dcatSdt = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k42 ) * catS
    dIncatdt = k32 * cat
    dIncatSdt = k42 * catS
    return [dSdt, dPdt, dcatdt, dcatSdt, dIncatdt, dIncatSdt]

def data_gen(idx, sigma = 0.0001, t_span = (0,9.9), yd = [0.4, 0.8], num_sample = 50):
    if idx in [1, 4]:
        args = 10**np.random.uniform(-3,3,4)
    elif idx in [2, 3, 5, 7, 8, 20]:
        args = 10**np.random.uniform(-3,3,6)
    elif idx in [6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19]:
        args = 10**np.random.uniform(-3,3,5)
        
    if idx in [1, 4]:
        args = args.tolist() + [0,0,0,0]
    elif idx in [2, 3, 5, 7, 8]:
        args = args.tolist() + [0,0]
    elif idx in [6]:
        args = args.tolist() + [0,0,0]
    elif idx in [9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19]:
        args = args.tolist()
        args.insert(-1,0)
        args = args + [0,0]
    elif idx in [20]:
        args = args.tolist()
        args.insert(-2,0)
        args.insert(-1,0)
    
    cat1 = np.random.uniform(0.01, 0.02)
    if idx in [1]:
        y_1 = [1,0,cat1,0]
    elif idx in [2, 3, 4, 5, 6, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19]:
        y_1 = [1,0,cat1,0,0]
    elif idx in [8, 10, 15, 20]:
        y_1 = [1,0,cat1,0,0,0]
    solution1 = solve_ivp(eval("func"+str(idx)), t_span, y_1, args=args, method = 'LSODA', t_eval=np.linspace(t_span[0], t_span[1], 100), rtol = 1e-6, atol = 1e-9)
    samp_idx1 = np.random.choice(solution1["y"].shape[1], num_sample, replace = False)
    solution1["t"] = solution1["t"][samp_idx1]
    solution1["y"] = solution1["y"][:,samp_idx1]
    ori1 = copy.copy(solution1["y"])
    if sigma > 0:
        solution1["y"] += np.random.normal(0, sigma, solution1["y"].shape[0]*solution1["y"].shape[1]).reshape(solution1["y"].shape)
    
    cat2 = np.random.uniform(0.045, 0.055)
    if idx in [1]:
        y_2 = [1,0,cat2,0]
    elif idx in [2, 3, 4, 5, 6, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19]:
        y_2 = [1,0,cat2,0,0]
    elif idx in [8, 10, 15, 20]:
        y_2 = [1,0,cat2,0,0,0]
    solution2 = solve_ivp(eval("func"+str(idx)), t_span, y_2, args=args, method = 'LSODA', t_eval=np.linspace(t_span[0], t_span[1], 100), rtol = 1e-6, atol = 1e-9)
    samp_idx2 = np.random.choice(solution2["y"].shape[1], num_sample, replace = False)
    solution2["t"] = solution2["t"][samp_idx2]
    solution2["y"] = solution2["y"][:,samp_idx2]
    ori2 = copy.copy(solution2["y"])
    if sigma > 0:
        solution2["y"] += np.random.normal(0, sigma, solution2["y"].shape[0]*solution2["y"].shape[1]).reshape(solution2["y"].shape)
    
    cat3 = np.random.uniform(0.09, 0.1)
    if idx in [1]:
        y_3 = [1,0,cat3,0]
    elif idx in [2, 3, 4, 5, 6, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19]:
        y_3 = [1,0,cat3,0,0]
    elif idx in [8, 10, 15, 20]:
        y_3 = [1,0,cat3,0,0,0]
    solution3 = solve_ivp(eval("func"+str(idx)), t_span, y_3, args=args, method = 'LSODA', t_eval=np.linspace(t_span[0], t_span[1], 100), rtol = 1e-6, atol = 1e-9)
    samp_idx3 = np.random.choice(solution3["y"].shape[1], num_sample, replace = False)
    solution3["t"] = solution3["t"][samp_idx3]
    solution3["y"] = solution3["y"][:,samp_idx3]
    ori3 = copy.copy(solution3["y"])
    if sigma > 0:
        solution3["y"] += np.random.normal(0, sigma, solution3["y"].shape[0]*solution3["y"].shape[1]).reshape(solution3["y"].shape)
    
    cat4 = eval("cat"+str(np.random.choice([1,2,3])))
    p = np.random.uniform(0.4,0.8)
    if idx in [1]:
        y_4 = [p,1-p,cat4,0]
    elif idx in [2, 3, 4, 5, 6, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19]:
        y_4 = [p,1-p,cat4,0,0]
    elif idx in [8, 10, 15, 20]:
        y_4 = [1,0,cat4,0,0,0]
    solution4 = solve_ivp(eval("func"+str(idx)), t_span, y_4, args=args, method = 'LSODA', t_eval=np.linspace(t_span[0], t_span[1], 100), rtol = 1e-6, atol = 1e-9) ## LSODA
    samp_idx4 = np.random.choice(solution4["y"].shape[1], num_sample, replace = False)
    solution4["t"] = solution4["t"][samp_idx4]
    solution4["y"] = solution4["y"][:,samp_idx4]
    ori4 = copy.copy(solution4["y"])
    if sigma > 0:
        solution4["y"] += np.random.normal(0, sigma, solution4["y"].shape[0]*solution4["y"].shape[1]).reshape(solution4["y"].shape)
    
    idx_yd = False
    if solution1.y[1][-1] >= yd[0] and solution1.y[1][-1] <= yd[1]:
        idx_yd = True
    if solution2.y[1][-1] >= yd[0] and solution2.y[1][-1] <= yd[1]:
        idx_yd = True
    if solution3.y[1][-1] >= yd[0] and solution3.y[1][-1] <= yd[1]:
        idx_yd = True
    
    if idx == 1:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat ,
d P / d t = k21 * cat <S> - k22 * cat * P ,
d cat / d t = ( k12 + k21 ) * cat <S> - ( k11 * S + k22 * P ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * cat <S> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 2:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat ,
d P / d t = k21 * cat <S> - k22 * cat * P ,
d cat / d t = ( k12 + k21 ) * cat <S> + 2 * k31 * cat <2> - ( k11 * S + k22 * P + 2 * k32 * cat ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * cat <S> ,
d cat <2> / d t = k32 * cat ** 2 - k31 * cat <2> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 3:
        lb = '''d S / d t = k12 * cat <2> <S> - k11 * S * cat <2> ,
d P / d t = k21 * cat <2> <S> - k22 * cat <2> * P ,
d cat / d t = 2 * k32 * cat <2> - 2 * k31 * cat ** 2 ,
d cat <2> / d t = ( k12 + k21 ) * cat <2> <S> + k31 * cat ** 2 - ( k11 * S + k22 * P + k32 ) * cat <2> ,
d cat <2> <S> / d t = ( k11 * S + k22 * P ) * cat <2> - ( k12 + k21 ) * cat <2> <S> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 4:
        lb = '''d S / d t = k12 * X * cat <S> - k11 * S * cat ,
d P / d t = k21 * X * cat <S> - k22 * cat * P ,
d cat / d t = ( k12 + k21 ) * X * cat <S> - ( k11 * S + k22 * P ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * X * cat <S> ,
d X / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * X * cat <S> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 5:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat ,
d P / d t = k31 * cat <P> - k32 * cat * P ,
d cat / d t = k12 * cat <S> + k31 * cat <P> - ( k11 * S + k32 * P ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * cat <P> ) * cat - ( k12 + k21 * cat ) * cat <S> ,
d cat <P> / d t = k21 * cat <S> * cat + k32 * P * cat - ( k31 + k22 * cat ) * cat <P> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 6:
        lb = '''d S / d t = k12 * cat <Star> <S> - k11 * S * cat <Star> ,
d P / d t = k21 * cat <Star> <S> - k22 * cat <Star> * P ,
d cat / d t = - k31 * cat ,
d cat <Star> / d t = k31 * cat + ( k12 + k21 ) * cat <Star> <S> - ( k11 * S + k22 * P ) * cat <Star> ,
d cat <Star> <S> / d t = ( k11 * S + k22 * P ) * cat <Star> - ( k12 + k21 ) * cat <Star> <S> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 7:
        lb = '''d S / d t = k12 * cat <S> <2> - k11 * S * cat <S> + k32 * cat <S> - k31 * S * cat ,
d P / d t = k21 * cat <S> <2> - k22 * cat <S> * P ,
d cat / d t = k32 * cat <S> - k31 * S * cat ,
d cat <S> / d t = k31 * S * cat - k32 * cat <S> + ( k12 + k21 ) * cat <S> <2> - ( k11 * S + k22 * P ) * cat <S> ,
d cat <S> <2> / d t = ( k11 * S + k22 * P ) * cat <S> - ( k12 + k21 ) * cat <S> <2> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 8:
        lb = '''d S / d t = k12 * cat <Star> <S> - k11 * S * cat <Star> ,
d P / d t = k21 * cat <Star> <S> - k22 * cat <Star> * P ,
d cat / d t = k32 * L * cat <Star> - k31 * cat ,
d cat <Star> / d t = k31 * cat - k32 * L * cat <Star> + ( k12 + k21 ) * cat <Star> <S> - ( k11 * S + k22 * P ) * cat <Star> ,
d cat <Star> <S> / d t = ( k11 * S + k22 * P ) * cat <Star> - ( k12 + k21 ) * cat <Star> <S> ,
d L / d t = k31 * cat - k32 * L * cat <Star> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 9:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat ,
d P / d t = k21 * cat <S> - k22 * cat * P ,
d cat / d t = ( k12 + k21 ) * cat <S> - ( k11 * S + k22 * P + k32 ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21) * cat <S> ,
d <In> cat / d t = k32 * cat .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 10:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat ,
d P / d t = k21 * cat <S> - k22 * cat * P ,
d cat / d t = ( k12 + k21 ) * cat <S> - ( k11 * S + k22 * P + k32 * Inhbt ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * cat <S> ,
d Inhbt / d t = - k32 * Inhbt * cat ,
d <In> cat <I> / d t = k32 * Inhbt * cat .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 11:
        lb = '''d S / d t = k12 * cat <S> - ( k11 + k32 ) * S * cat ,
d P / d t = k21 * cat <S> - k22 * cat * P ,
d cat / d t = ( k12 + k21 ) * cat <S> - ( k11 * S + k22 * P + k32 * S ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * cat <S> ,
d <In> cat <S> / d t = k32 * S * cat .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 12:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat ,
d P / d t = k21 * cat <S> - ( k22 + k32 ) * cat * P ,
d cat / d t = ( k12 + k21 ) * cat <S> - ( k11 * S + k22 * P + k32 * P ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * cat <S> ,
d <In> cat <P> / d t = k32 * P * cat .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 13:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat ,
d P / d t = k21 * cat <S> - k22 * cat * P ,
d cat / d t = ( k12 + k21 ) * cat <S> - ( k11 * S + k22 * P + 2 * k32 * cat ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 ) * cat <S> ,
d <In> cat <2> / d t = k32 * cat ** 2 .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 14:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat ,
d P / d t = k21 * cat <S> - k22 * cat * P ,
d cat / d t = ( k12 + k21 ) * cat <S> - ( k11 * S + k22 * P ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k32 ) * cat <S> ,
d <In> cat <S> / d t = k32 * cat <S> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 15:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat ,
d P / d t = k21 * cat <S> - k22 * cat * P ,
d cat / d t = ( k12 + k21 ) * cat <S> - ( k11 * S + k22 * P ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k32 * Inhbt ) * cat <S> ,
d Inhbt / d t = - k32 * Inhbt * cat <S> ,
d <In> cat <S> <I> / d t = k32 * Inhbt * cat <S> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 16:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat - k32 * S * cat <S> ,
d P / d t = k21 * cat <S> - k22 * cat * P ,
d cat / d t = ( k12 + k21 ) * cat <S> - ( k11 * S + k22 * P ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k32 * S ) * cat <S> ,
d <In> cat <S> <2> / d t = k32 * S * cat <S> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 17:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat ,
d P / d t = k21 * cat <S> - k22 * cat * P - k32 * P * cat <S> ,
d cat / d t = ( k12 + k21 ) * cat <S> - ( k11 * S + k22 * P ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k32 * P ) * cat <S> ,
d <In> cat <S> <P> / d t = k32 * P * cat <S> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 18:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat ,
d P / d t = k21 * cat <S> - k22 * cat * P ,
d cat / d t = ( k12 + k21 ) * cat <S> - ( k11 * S + k22 * P ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k32 * cat <S> ) * cat <S> ,
d <In> cat <2> <S> <2> / d t = k32 * cat <S> ** 2 .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 19:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat ,
d P / d t = k21 * cat <S> - k22 * cat * P ,
d cat / d t = ( k12 + k21 ) * cat <S> - ( k11 * S + k22 * P + k32 * cat <S> ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k32 * cat ) * cat <S> ,
d <In> cat <2> <S> / d t = k32 * cat * cat <S> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    elif idx == 20:
        lb = '''d S / d t = k12 * cat <S> - k11 * S * cat ,
d P / d t = k21 * cat <S> - k22 * cat * P ,
d cat / d t = ( k12 + k21 ) * cat <S> - ( k11 * S + k22 * P + k32 ) * cat ,
d cat <S> / d t = ( k11 * S + k22 * P ) * cat - ( k12 + k21 + k42 ) * cat <S> ,
d <In> cat / d t = k32 * cat ,
d <In> cat <S> / d t = k42 * cat <S> .'''.replace(" S "," [S] ").replace(" P "," [P] ").replace(" cat "," [cat] ").replace("**","^").replace(" X "," [X] ").replace(" L "," [L] ").replace(" Inhbt "," [Inhbt] ")
    
    return [solution1,solution2,solution3,solution4],[y_1,y_2,y_3,y_4],idx, lb ,args, [ori1, ori2, ori3, ori4], idx_yd

def num_encoder(num):
    n_str = ""
    if num >=0:
        n_str += "+;"
    else:
        n_str += "-;"
    num_norm = "{:.3e}".format(num)
    n1,n2 = num_norm.split("e")
    n_str += "N"+str(int(abs(float(n1)*1000)))+";"
    n_str += "E" + str(int(n2)-3)
    return n_str

def graph_gen1(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","mul","-1","mul","k3","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","mul","-1","mul","add","mul","k0","x_0","mul","k3","x_1","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,8),(8,9),(8,16),(9,10),(9,13),(10,11),(10,12),(13,14),(13,15)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"

    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","k2","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,16),(13,14),(13,15)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)

    seq = (seq1+seq2+seq3+seq4).split(";")

    return [G1,G2,G3,G4],seq

def graph_gen2(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","mul","-1","mul","k3","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","add","mul","2","mul","k4","x_4","mul","-1",
           "mul","add","mul","k0","x_0","add","mul","k3","x_1","mul","k5","x_2","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,27),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,12),(7,8),(7,9),(9,10),(9,11),
                      (12,13),(12,14),(14,15),(14,26),(15,16),(15,19),(16,17),(16,18),(19,20),(19,23),
                      (20,21),(20,22),(23,24),(23,25)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"

    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","k2","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,16),(13,14),(13,15)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["add","mul","k5","pow2","x_2","mul","-1","mul","k4","x_4"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,10),seq5)])
    G5.add_edges_from([(0,1),(0,5),(1,2),(1,3),(3,4),(5,6),(5,7),(7,8),(7,9)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen3(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_4","mul","-1","mul","k0","mul","x_0","x_3"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_4","mul","-1","mul","k3","mul","x_3","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","2","mul","k5","x_3","mul","-2","mul","k4","pow2","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,12),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,3),(3,4),(3,5),(6,7),(6,8),(8,9),(8,10),(10,11)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;").replace(";-2;",";-;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"

    G4 = nx.Graph()
    seq4 = ["add","mul","add","k1","k2","x_3","add","mul","k4","pow2","x_2","mul","-1",
           "mul","add","mul","k0","x_0","add","mul","k3","x_1","k5","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,24),seq4)])
    G4.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,11),(7,8),(7,9),
                      (9,10),(11,12),(11,13),(13,14),(13,23),(14,15),(14,18),(15,16),(15,17),
                      (18,19),(18,22),(19,20),(19,21)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_3","mul","-1","mul","add","k1","k2","x_4"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq5)])
    G5.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),
                      (10,11),(10,12),(12,13),(12,16),(13,14),(13,15)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen4(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","mul","x_4","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,13),seq1)])
    G1.add_edges_from([(0,1),(0,6),(1,2),(1,3),(3,4),(3,5),(6,7),(6,8),(8,9),(8,10),(10,11),(10,12)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","mul","x_4","x_3","mul","-1","mul","k3","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,13),seq2)])
    G2.add_edges_from([(0,1),(0,6),(1,2),(1,3),(3,4),(3,5),(6,7),(6,8),(8,9),(8,10),(10,11),(10,12)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","mul","x_4","x_3","mul","-1","mul","add","mul",
           "k0","x_0","mul","k3","x_1","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,19),seq3)])
    G3.add_edges_from([(0,1),(0,8),(1,2),(1,5),(2,3),(2,4),(5,6),(5,7),(8,9),(8,10),
                      (10,11),(10,18),(11,12),(11,15),(12,13),(12,14),(15,16),(15,17)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"

    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul",
           "-1","mul","add","k1","k2","mul","x_4","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,19),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,16),(13,14),(13,15),
                      (16,17),(16,18)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["add","mul","add","mul","k0","x_0","mul","k3",'x_1',"x_2","mul","-1","mul","add","k1","k2",
           "mul","x_4","x_3"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,19),seq5)])
    G5.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),
                      (10,11),(10,12),(12,13),(12,16),(13,14),(13,15),(16,17),(16,18)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen5(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k4","x_4","mul","-1","mul","k5","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","k1","x_3","add","mul","k4","x_4","mul","-1","mul","add","mul","k0","x_0","mul",
           "k5","x_1","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,19),seq3)])
    G3.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,8),(5,6),(5,7),(8,9),(8,10),(10,11),(10,18),
                      (11,12),(11,15),(12,13),(12,14),(15,16),(15,17)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"

    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_4","x_2","mul",
           "-1","mul","add","k1","mul","k2","x_2","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,19),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,18),(13,14),(13,15),
                      (15,16),(15,17)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["add","mul","k2","mul","x_3","x_2","add","mul","k5","mul","x_1","x_2","mul","-1",
           "mul","add","k4","mul","k3","x_2","x_4"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,21),seq5)])
    G5.add_edges_from([(0,1),(0,6),(1,2),(1,3),(3,4),(3,5),(6,7),(6,12),(7,8),(7,9),(9,10),(9,11),
                      (12,13),(12,14),(14,15),(14,20),(15,16),(15,17),(17,18),(17,19)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen6(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_4","mul","-1","mul","k0","mul","x_0","x_3"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k4","x_4","mul","-1","mul","k5","mul","x_3","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["mul","-1","mul","k4","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,5),seq3)])
    G3.add_edges_from([(0,1),(0,2),(2,3),(2,4)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"

    G4 = nx.Graph()
    seq4 = ["add","mul","k4","x_2","add","mul","add","k1","k2","x_4","mul",
           "-1","mul","add","mul","k0","x_0","mul","k3","x_1","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,21),seq4)])
    G4.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,10),(5,6),(5,9),(6,7),(6,8),
                      (10,11),(10,12),(12,13),(12,20),(13,14),(13,17),(14,15),(14,16),(17,18),(17,19)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_3","mul","-1","mul",
           "add","k1","k2","x_4"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq5)])
    G5.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),
                      (12,13),(12,16),(13,14),(13,15)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen7(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_4","add","mul","-1","mul","k0","mul","x_0","x_3",
           "add","mul","k5","x_3","mul","-1","mul","k4","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,23),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,12),(5,6),(5,7),(7,8),(7,9),
                      (9,10),(9,11),(12,13),(12,16),(13,14),(13,15),(16,17),(16,18),
                      (18,19),(18,20),(20,21),(20,22)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_4","mul","-1","mul","k3","mul","x_3","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","k5","x_3","mul","-1","mul","k4","mul","x_0","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq3)])
    G3.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"

    G4 = nx.Graph()
    seq4 = ["add","mul","k4","mul","x_0","x_2","add","mul","-1","mul","k5","x_3",
           "add","mul","add","k1","k2","x_4","mul","-1","mul","add","mul","k0","x_0",
           "mul","k3","x_1","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,29),seq4)])
    G4.add_edges_from([(0,1),(0,6),(1,2),(1,3),(3,4),(3,5),(6,7),(6,12),(7,8),(7,9),
                      (9,10),(9,11),(12,13),(12,18),(13,14),(13,17),(14,15),(14,16),
                      (18,19),(18,20),(20,21),(20,28),(21,22),(21,25),(22,23),(22,24),(25,26),(25,27)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_3","mul","-1","mul",
           "add","k1","k2","x_4"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq5)])
    G5.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),
                      (12,13),(12,16),(13,14),(13,15)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen8(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_4","mul","-1","mul","k0","mul","x_0","x_3"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k4","x_4","mul","-1","mul","k5","mul","x_3","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","k5","mul","x_5","x_3","mul","-1","mul","k4","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,3),(3,4),(3,5),(6,7),(6,8),(8,9),(8,10)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"

    G4 = nx.Graph()
    seq4 = ["add","mul","k4","x_2","add","mul","-1","mul","k5","mul","x_5","x_3",
           "add","mul","add","k1","k2","x_4","mul","-1","mul","add","mul","k0","x_0",
           "mul","k3","x_1","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,29),seq4)])
    G4.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,12),(5,6),(5,7),(7,8),(7,9),
                      (9,10),(9,11),(12,13),(12,18),(13,14),(13,17),(14,15),(14,16),
                      (18,19),(18,20),(20,21),(20,28),(21,22),(21,25),(22,23),(22,24),(25,26),(25,27)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_3","mul","-1","mul",
           "add","k1","k2","x_4"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq5)])
    G5.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),
                      (12,13),(12,16),(13,14),(13,15)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
    seq5 += ";|;"
    
    G6 = nx.Graph()
    seq6 = ["add","mul","k4","x_2","mul","-1","mul","k5","mul","x_5","x_3"]
    G6.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq6)])
    G6.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq6 = ";".join(seq6).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq6 = seq6.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5+seq6).split(";")

    return [G1,G2,G3,G4,G5,G6],seq

def graph_gen9(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","mul","-1","mul","k3","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","mul","-1","mul","add","mul","k0","x_0",
           "add","mul","k3","x_1","k5","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,19),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,8),(8,9),(8,18),
                      (9,10),(9,13),(10,11),(10,12),(13,14),(13,17),(14,15),(14,16)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"

    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","k2","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,16),(13,14),(13,15)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["mul","k5","x_2"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,3),seq5)])
    G5.add_edges_from([(0,1),(0,2)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen10(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","mul","-1","mul","k3","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","mul","-1","mul","add","mul","k0","x_0",
           "add","mul","k3","x_1","mul","k5","x_4","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,21),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,8),(8,9),(8,20),
                      (9,10),(9,13),(10,11),(10,12),(13,14),(13,17),(14,15),(14,16),(17,18),(17,19)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"

    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","k2","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,16),(13,14),(13,15)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["mul","-1","mul","k5","mul","x_4","x_2"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,7),seq5)])
    G5.add_edges_from([(0,1),(0,2),(2,3),(2,4),(4,5),(4,6)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
    seq5 += ";|;"
    
    G6 = nx.Graph()
    seq6 = ["mul","k5","mul","x_4","x_2"]
    G6.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,5),seq6)])
    G6.add_edges_from([(0,1),(0,2),(2,3),(2,4)])
    seq6 = ";".join(seq6).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq6 = seq6.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5+seq6).split(";")

    return [G1,G2,G3,G4,G5,G6],seq

def graph_gen11(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","add","k0","k5","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,13),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,10),(7,8),(7,9),(10,11),(10,12)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","mul","-1","mul","k3","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","mul","-1","mul","add","mul","k0","x_0",
           "add","mul","k3","x_1","mul","k5","x_0","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,21),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,8),(8,9),(8,20),
                      (9,10),(9,13),(10,11),(10,12),(13,14),(13,17),(14,15),(14,16),(17,18),(17,19)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"

    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","k2","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,16),(13,14),(13,15)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["mul","k5","mul","x_0","x_2"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,5),seq5)])
    G5.add_edges_from([(0,1),(0,2),(2,3),(2,4)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen12(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","mul","-1","mul","add","k3","k5","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,13),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,10),(7,8),(7,9),(10,11),(10,12)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","mul","-1","mul","add","mul","k0","x_0",
           "add","mul","k3","x_1","mul","k5","x_1","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,21),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,8),(8,9),(8,20),
                      (9,10),(9,13),(10,11),(10,12),(13,14),(13,17),(14,15),(14,16),(17,18),(17,19)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"

    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","k2","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,16),(13,14),(13,15)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["mul","k5","mul","x_1","x_2"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,5),seq5)])
    G5.add_edges_from([(0,1),(0,2),(2,3),(2,4)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen13(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","mul","-1","mul","k3","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","mul","-1","mul","add","mul","k0","x_0",
           "add","mul","k3","x_1","mul","2","mul","k5","x_2","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,23),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,8),(8,9),(8,22),
                      (9,10),(9,13),(10,11),(10,12),(13,14),(13,17),(14,15),(14,16),(17,18),(17,19),
                      (19,20),(19,21)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"

    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","k2","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,16),(13,14),(13,15)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["mul","k5","pow2","x_2"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,4),seq5)])
    G5.add_edges_from([(0,1),(0,2),(2,3)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen14(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","mul","-1","mul","k3","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","mul","-1","mul","add","mul","k0","x_0","mul","k3","x_1","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,8),(8,9),(8,16),(9,10),(9,13),(10,11),(10,12),(13,14),(13,15)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"
    
    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","add","k2","k5","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,19),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,18),(13,14),(13,15),(15,16),(15,17)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["mul","k5","x_3"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,3),seq5)])
    G5.add_edges_from([(0,1),(0,2)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen15(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","mul","-1","mul","k3","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","mul","-1","mul","add","mul","k0","x_0","mul","k3","x_1","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,8),(8,9),(8,16),(9,10),(9,13),(10,11),(10,12),(13,14),(13,15)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"
    
    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","add","k2","mul","k5","x_4","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,21),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,20),(13,14),(13,15),(15,16),(15,17),
                      (17,18),(17,19)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    
    G5 = nx.Graph()
    seq5 = ["mul","-1","mul","k5","mul","x_4","x_3"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,7),seq5)])
    G5.add_edges_from([(0,1),(0,2),(2,3),(2,4),(4,5),(4,6)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
    seq5 += ";|;"
    
    G6 = nx.Graph()
    seq6 = ["mul","k5","mul","x_4","x_3"]
    G6.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,5),seq6)])
    G6.add_edges_from([(0,1),(0,2),(2,3),(2,4)])
    seq6 = ";".join(seq6).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq6 = seq6.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5+seq6).split(";")

    return [G1,G2,G3,G4,G5,G6],seq

def graph_gen16(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","add","mul","-1","mul","k0","mul","x_0","x_2",
           "mul","-1","mul","k5","mul","x_0","x_3"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,19),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,12),(5,6),(5,7),(7,8),(7,9),
                      (9,10),(9,11),(12,13),(12,14),(14,15),(14,16),(16,17),(16,18)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","mul","-1","mul","k3","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","mul","-1","mul","add","mul","k0","x_0","mul","k3","x_1","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,8),(8,9),(8,16),(9,10),(9,13),(10,11),(10,12),(13,14),(13,15)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"
    
    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","add","k2","mul","k5","x_0","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,21),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,20),(13,14),(13,15),(15,16),(15,17),
                      (17,18),(17,19)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["mul","k5","mul","x_0","x_3"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,5),seq5)])
    G5.add_edges_from([(0,1),(0,2),(2,3),(2,4)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen17(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","add","mul","-1","mul","k3","mul","x_2","x_1","mul","-1",
           "mul","k5","mul","x_1","x_3"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,12),(5,6),(5,7),(7,8),(7,9),
                      (9,10),(9,11),(12,13),(12,14),(14,15),(14,16),(16,17),(16,18)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","mul","-1","mul","add","mul","k0","x_0","mul","k3","x_1","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,8),(8,9),(8,16),(9,10),(9,13),(10,11),(10,12),(13,14),(13,15)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"
    
    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","add","k2","mul","k5","x_1","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,21),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,20),(13,14),(13,15),(15,16),(15,17),
                      (17,18),(17,19)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["mul","k5","mul","x_1","x_3"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,5),seq5)])
    G5.add_edges_from([(0,1),(0,2),(2,3),(2,4)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen18(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","mul","-1","mul","k3","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","mul","-1","mul","add","mul","k0","x_0","mul","k3","x_1","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,17),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,8),(8,9),(8,16),(9,10),(9,13),(10,11),(10,12),(13,14),(13,15)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"
    
    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","add","k2","mul","k5","x_3","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,21),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,20),(13,14),(13,15),(15,16),(15,17),
                      (17,18),(17,19)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["mul","k5","pow2","x_3"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,4),seq5)])
    G5.add_edges_from([(0,1),(0,2),(2,3)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen19(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","mul","-1","mul","k3","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","mul","-1","mul","add","mul","k0","x_0",
           "add","mul","k3","x_1","mul","k5","x_3","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,21),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,8),(8,9),(8,20),
                      (9,10),(9,13),(10,11),(10,12),(13,14),(13,17),(14,15),(14,16),(17,18),(17,19)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"
    
    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","add","k2","mul","k5","x_2","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,21),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,20),(13,14),(13,15),(15,16),(15,17),
                      (17,18),(17,19)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    G5 = nx.Graph()
    seq5 = ["mul","k5","mul","x_2","x_3"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,5),seq5)])
    G5.add_edges_from([(0,1),(0,2),(2,3),(2,4)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5).split(";")

    return [G1,G2,G3,G4,G5],seq

def graph_gen20(ks):
    G1 = nx.Graph()
    seq1 = ["add","mul","k1","x_3","mul","-1","mul","k0","mul","x_0","x_2"]
    G1.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq1)])
    G1.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq1 = ";".join(seq1).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq1 = seq1.replace("k"+str(i),n_str)
    seq1 += ";|;"

    G2 = nx.Graph()
    seq2 = ["add","mul","k2","x_3","mul","-1","mul","k3","mul","x_2","x_1"]
    G2.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,11),seq2)])
    G2.add_edges_from([(0,1),(0,4),(1,2),(1,3),(4,5),(4,6),(6,7),(6,8),(8,9),(8,10)])
    seq2 = ";".join(seq2).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq2 = seq2.replace("k"+str(i),n_str)
    seq2 += ";|;"

    G3 = nx.Graph()
    seq3 = ["add","mul","add","k1","k2","x_3","mul","-1","mul","add","mul","k0","x_0",
           "add","mul","k3","x_1","k5","x_2"]
    G3.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,19),seq3)])
    G3.add_edges_from([(0,1),(0,6),(1,2),(1,5),(2,3),(2,4),(6,7),(6,8),(8,9),(8,18),
                      (9,10),(9,13),(10,11),(10,12),(13,14),(13,17),(14,15),(14,16)])
    seq3 = ";".join(seq3).replace(";-1;",";-;N1000;E-3;").replace(";2;",";+;N2000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq3 = seq3.replace("k"+str(i),n_str)
    seq3 += ";|;"
    
    G4 = nx.Graph()
    seq4 = ["add","mul","add","mul","k0","x_0","mul","k3","x_1","x_2","mul","-1","mul","add","k1","add","k2","k7","x_3"]
    G4.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,19),seq4)])
    G4.add_edges_from([(0,1),(0,10),(1,2),(1,9),(2,3),(2,6),(3,4),(3,5),(6,7),(6,8),(10,11),(10,12),(12,13),(12,18),(13,14),(13,15),(15,16),(15,17)])
    seq4 = ";".join(seq4).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq4 = seq4.replace("k"+str(i),n_str)
    seq4 += ";|;"

    
    G5 = nx.Graph()
    seq5 = ["mul","k5","x_2"]
    G5.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,3),seq5)])
    G5.add_edges_from([(0,1),(0,2)])
    seq5 = ";".join(seq5).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq5 = seq5.replace("k"+str(i),n_str)
    seq5 += ";|;"
    
    G6 = nx.Graph()
    seq6 = ["mul","k7","x_3"]
    G6.add_nodes_from([(i,{"symbol":j}) for i,j in zip(range(0,3),seq6)])
    G6.add_edges_from([(0,1),(0,2)])
    seq6 = ";".join(seq6).replace(";-1;",";-;N1000;E-3;")
    for i in range(len(ks)):
        n_str = num_encoder(ks[i])
        seq6 = seq6.replace("k"+str(i),n_str)
        
    seq = (seq1+seq2+seq3+seq4+seq5+seq6).split(";")

    return [G1,G2,G3,G4,G5,G6],seq

def batch_generate(batch_size, sigma = 1e-5, idx = None, i_li = None):
    n = 0
    batch = {}
    batch["times"] = []
    batch["trajectory"] = []
    batch["trajectory_clean"] = []
    batch["tree_encoded"] = []
    batch["infos"] = {}
    batch["infos"]["dimension"] = []
    batch["infos"]["class"] = []
    ind = True
    while True:
        if n >= batch_size:
            break
        if ind:
            if i_li:
                i = np.random.choice(i_li)
            else:
                if not idx:
                    i = np.random.choice(range(1,21))
                else:
                    i = idx
        # x, cat, cls, y, ks, idx_yd = data_gen(i, sigma=sigma)
        try:
            x, cat, cls, y, ks, ori, idx_yd = func_timeout(2,data_gen, args=(i,sigma,))
            ind = True
        except:
            ind = False
            continue
        
        if idx_yd:
            all_idx = np.random.choice(range(len(x)))
            all_data = x[all_idx]
            trajectory_clean = ori[all_idx].transpose(1,0)
            times = all_data["t"]
            trajectory = all_data["y"].transpose(1,0)
            dimension = trajectory.shape[1]
            Gs, tree_encoded = eval("graph_gen"+str(i))(ks)
            if "N0" in tree_encoded:
                continue
            n+=1
            batch["times"].append(times)
            batch["trajectory"].append(trajectory)
            batch["trajectory_clean"].append(trajectory_clean)
            batch["tree_encoded"].append(tree_encoded)
            batch["infos"]["dimension"].append(dimension)
            batch["infos"]["class"].append(i)
    return batch

import pickle
import pandas as pd
dataframes = []

def load_pickle_file():
    global dataframes

    if len(dataframes) == 0:
        for i in range(1, 21):
            filename = f"/home/tianjidong/mechanism/reaction_mechanism_classification/Data/mechanism_dsr_{i}_init.pkl"
            with open(filename, 'rb') as f:
                df = pickle.load(f)
                dataframes.append(df)
        dataframes = pd.concat(dataframes, ignore_index=True)

def batch_generate_1(batch_size):
    global dataframes

    if len(dataframes) == 0:
        load_pickle_file()

    batch = {}
    batch["times"] = []
    batch["trajectory"] = []
    batch["trajectory_clean"] = []
    batch["tree_encoded"] = []
    batch["infos"] = {}
    batch["infos"]["dimension"] = []
    batch["infos"]["class"] = []

    sample = dataframes.sample(n=batch_size)
    
    batch["tree_encoded"] = sample['tree_encoded'].tolist()
    for i in range(batch_size):
        time = sample['time'].iloc[0][0]
        batch["times"].append(time)
        class_number = sample['class'].iloc[i]
        substrate = sample["substrate"].iloc[i]
        product = sample['product'].iloc[i]
        catalyst = sample['catalyst'].iloc[i]
        other = sample['other'].iloc[i].transpose(1,0)
        trajectory = np.concatenate((np.column_stack((substrate, product, catalyst)), other), axis=1)
        dimension = trajectory.shape[1]
        batch["trajectory"].append(trajectory)
        batch["infos"]["dimension"].append(dimension)
        batch["infos"]["class"].append(class_number)
    return batch


import pickle
import pandas as pd
dataframes_without_6_7_8 = []

def load_pickle_file_without_6_7_8():
    global dataframes_without_6_7_8

    if len(dataframes_without_6_7_8) == 0:
        for i in range(1, 6):
            filename = f"/home/tianjidong/mechanism/reaction_mechanism_classification/Data/mechanism_dsr_{i}_init.pkl"
            with open(filename, 'rb') as f:
                df = pickle.load(f)
                dataframes_without_6_7_8.append(df)
        for i in range(9, 21):
            filename = f"/home/tianjidong/mechanism/reaction_mechanism_classification/Data/mechanism_dsr_{i}_init.pkl"
            with open(filename, 'rb') as f:
                df = pickle.load(f)
                dataframes_without_6_7_8.append(df)
        dataframes_without_6_7_8 = pd.concat(dataframes_without_6_7_8, ignore_index=True)

def batch_generate_2(batch_size):
    global dataframes_without_6_7_8

    if len(dataframes_without_6_7_8) == 0:
        load_pickle_file_without_6_7_8()

    batch = {}
    batch["times"] = []
    batch["trajectory"] = []
    batch["trajectory_clean"] = []
    batch["tree_encoded"] = []
    batch["infos"] = {}
    batch["infos"]["dimension"] = []
    batch["infos"]["class"] = []

    sample = dataframes_without_6_7_8.sample(n=batch_size)
    
    batch["tree_encoded"] = sample['tree_encoded'].tolist()
    for i in range(batch_size):
        time = sample['time'].iloc[0][0]
        batch["times"].append(time)
        class_number = sample['class'].iloc[i]
        substrate = sample["substrate"].iloc[i]
        product = sample['product'].iloc[i]
        catalyst = sample['catalyst'].iloc[i]
        other = sample['other'].iloc[i].transpose(1,0)
        trajectory = np.concatenate((np.column_stack((substrate, product, catalyst)), other), axis=1)
        dimension = trajectory.shape[1]
        batch["trajectory"].append(trajectory)
        batch["infos"]["dimension"].append(dimension)
        batch["infos"]["class"].append(class_number)
    return batch


import pickle
import pandas as pd
dataframes_without_5_6_20 = []

def load_pickle_file_without_5_6_20():
    global dataframes_without_5_6_20

    if len(dataframes_without_5_6_20) == 0:
        for i in range(1, 5):
            filename = f"/home/tianjidong/mechanism/reaction_mechanism_classification/Data/mechanism_dsr_{i}_init.pkl"
            with open(filename, 'rb') as f:
                df = pickle.load(f)
                dataframes_without_5_6_20.append(df)
        for i in range(7, 20):
            filename = f"/home/tianjidong/mechanism/reaction_mechanism_classification/Data/mechanism_dsr_{i}_init.pkl"
            with open(filename, 'rb') as f:
                df = pickle.load(f)
                dataframes_without_5_6_20.append(df)
        dataframes_without_5_6_20 = pd.concat(dataframes_without_5_6_20, ignore_index=True)

def batch_generate_3(batch_size):
    global dataframes_without_5_6_20

    if len(dataframes_without_5_6_20) == 0:
        load_pickle_file_without_5_6_20()

    batch = {}
    batch["times"] = []
    batch["trajectory"] = []
    batch["trajectory_clean"] = []
    batch["tree_encoded"] = []
    batch["infos"] = {}
    batch["infos"]["dimension"] = []
    batch["infos"]["class"] = []

    sample = dataframes_without_5_6_20.sample(n=batch_size)
    
    batch["tree_encoded"] = sample['tree_encoded'].tolist()
    for i in range(batch_size):
        time = sample['time'].iloc[0][0]
        batch["times"].append(time)
        class_number = sample['class'].iloc[i]
        substrate = sample["substrate"].iloc[i]
        product = sample['product'].iloc[i]
        catalyst = sample['catalyst'].iloc[i]
        other = sample['other'].iloc[i].transpose(1,0)
        trajectory = np.concatenate((np.column_stack((substrate, product, catalyst)), other), axis=1)
        dimension = trajectory.shape[1]
        batch["trajectory"].append(trajectory)
        batch["infos"]["dimension"].append(dimension)
        batch["infos"]["class"].append(class_number)
    return batch


import pickle
import pandas as pd
dataframes = []

def load_pickle_file_nv1():
    global dataframes

    if len(dataframes) == 0:
        for i in range(1, 21):
            filename = f"/home/tianjidong/mechanism/reaction_mechanism_classification/Data/mechanism_dsr_{i}_init_v2.pkl"
            with open(filename, 'rb') as f:
                df = pickle.load(f)
                dataframes.append(df)
        dataframes = pd.concat(dataframes, ignore_index=True)

def batch_generate_nv1(batch_size):
    global dataframes

    if len(dataframes) == 0:
        load_pickle_file_nv1()

    batch = {}
    batch["times"] = []
    batch["trajectory"] = []
    batch["trajectory_clean"] = []
    batch["tree_encoded"] = []
    batch["infos"] = {}
    batch["infos"]["dimension"] = []
    batch["infos"]["class"] = []
    batch['prompt']= []

    sample = dataframes.sample(n=batch_size)
    
    batch["tree_encoded"] = sample['tree_encoded'].tolist()
    for i in range(batch_size):
        time = sample['time'].iloc[0][0]
        batch["times"].append(time)
        class_number = sample['class'].iloc[i]
        substrate = sample["substrate"].iloc[i]
        product = sample['product'].iloc[i]
        catalyst = sample['catalyst'].iloc[i]
        other = sample['other'].iloc[i].transpose(1,0)
        trajectory = np.concatenate((np.column_stack((substrate, product, catalyst)), other), axis=1)
        dimension = trajectory.shape[1]
        batch["trajectory"].append(trajectory)
        batch["infos"]["dimension"].append(dimension)
        batch["infos"]["class"].append(class_number)
        batch['prompt'].append(sample['prompt'].iloc[i])
    return batch

import pickle
import pandas as pd
dataframes_nv2_without_6_7_8 = []

def load_pickle_file_nv2_without_6_7_8():
    global dataframes_nv2_without_6_7_8

    if len(dataframes_nv2_without_6_7_8) == 0:
        for i in range(1, 6):
            filename = f"/home/tianjidong/mechanism/reaction_mechanism_classification/Data/mechanism_dsr_{i}_init_v2.pkl"
            with open(filename, 'rb') as f:
                df = pickle.load(f)
                dataframes_nv2_without_6_7_8.append(df)
        for i in range(9, 21):
            filename = f"/home/tianjidong/mechanism/reaction_mechanism_classification/Data/mechanism_dsr_{i}_init_v2.pkl"
            with open(filename, 'rb') as f:
                df = pickle.load(f)
                dataframes_nv2_without_6_7_8.append(df)
        dataframes_nv2_without_6_7_8 = pd.concat(dataframes_nv2_without_6_7_8, ignore_index=True)

def batch_generate_nv2(batch_size):
    global dataframes_nv2_without_6_7_8

    if len(dataframes_nv2_without_6_7_8) == 0:
        load_pickle_file_nv2_without_6_7_8()

    batch = {}
    batch["times"] = []
    batch["trajectory"] = []
    batch["trajectory_clean"] = []
    batch["tree_encoded"] = []
    batch["infos"] = {}
    batch["infos"]["dimension"] = []
    batch["infos"]["class"] = []
    batch['prompt']= []

    sample = dataframes_nv2_without_6_7_8.sample(n=batch_size)
    
    batch["tree_encoded"] = sample['tree_encoded'].tolist()
    for i in range(batch_size):
        time = sample['time'].iloc[0][0]
        batch["times"].append(time)
        class_number = sample['class'].iloc[i]
        substrate = sample["substrate"].iloc[i]
        product = sample['product'].iloc[i]
        catalyst = sample['catalyst'].iloc[i]
        other = sample['other'].iloc[i].transpose(1,0)
        trajectory = np.concatenate((np.column_stack((substrate, product, catalyst)), other), axis=1)
        dimension = trajectory.shape[1]
        batch["trajectory"].append(trajectory)
        batch["infos"]["dimension"].append(dimension)
        batch["infos"]["class"].append(class_number)
        batch['prompt'].append(sample['prompt'].iloc[i])
    return batch

import pickle
import pandas as pd
dataframes_nv3_without_5_6_20 = []

def load_pickle_file_nv3_without_5_6_20():
    global dataframes_nv3_without_5_6_20

    if len(dataframes_nv3_without_5_6_20) == 0:
        for i in range(1, 5):
            filename = f"/home/tianjidong/mechanism/reaction_mechanism_classification/Data/mechanism_dsr_{i}_init_v2.pkl"
            with open(filename, 'rb') as f:
                df = pickle.load(f)
                dataframes_nv3_without_5_6_20.append(df)
        for i in range(7, 20):
            filename = f"/home/tianjidong/mechanism/reaction_mechanism_classification/Data/mechanism_dsr_{i}_init_v2.pkl"
            with open(filename, 'rb') as f:
                df = pickle.load(f)
                dataframes_nv3_without_5_6_20.append(df)
        dataframes_nv3_without_5_6_20 = pd.concat(dataframes_nv3_without_5_6_20, ignore_index=True)

def batch_generate_nv3(batch_size):
    global dataframes_nv3_without_5_6_20

    if len(dataframes_nv3_without_5_6_20) == 0:
        load_pickle_file_nv3_without_5_6_20()

    batch = {}
    batch["times"] = []
    batch["trajectory"] = []
    batch["trajectory_clean"] = []
    batch["tree_encoded"] = []
    batch["infos"] = {}
    batch["infos"]["dimension"] = []
    batch["infos"]["class"] = []
    batch['prompt']= []

    sample = dataframes_nv3_without_5_6_20.sample(n=batch_size)
    
    batch["tree_encoded"] = sample['tree_encoded'].tolist()
    for i in range(batch_size):
        time = sample['time'].iloc[0][0]
        batch["times"].append(time)
        class_number = sample['class'].iloc[i]
        substrate = sample["substrate"].iloc[i]
        product = sample['product'].iloc[i]
        catalyst = sample['catalyst'].iloc[i]
        other = sample['other'].iloc[i].transpose(1,0)
        trajectory = np.concatenate((np.column_stack((substrate, product, catalyst)), other), axis=1)
        dimension = trajectory.shape[1]
        batch["trajectory"].append(trajectory)
        batch["infos"]["dimension"].append(dimension)
        batch["infos"]["class"].append(class_number)
        batch['prompt'].append(sample['prompt'].iloc[i])
    return batch


dataframes_v3 = []
def load_pickle_file_v3():
    global dataframes_v3

    if len(dataframes_v3) == 0:
        for i in range(1, 21):
            filename = f"/home/tianjidong/mechanism/reaction_mechanism_classification/Data/mechanism_dsr_{i}_init_v3.pkl"
            with open(filename, 'rb') as f:
                df = pickle.load(f)
                dataframes_v3.append(df)
        dataframes_v3 = pd.concat(dataframes_v3, ignore_index=True)

def batch_generate_v3(batch_size):
    global dataframes_v3

    if len(dataframes) == 0:
        load_pickle_file_v3()

    batch = {}
    batch["times"] = []
    batch["trajectory"] = []
    batch["trajectory_clean"] = []
    batch["tree_encoded"] = []
    batch["infos"] = {}
    batch["infos"]["dimension"] = []
    batch["infos"]["class"] = []
    batch['condition'] = []
    batch['prompt']= []
    batch['full_equation'] = []

    sample = dataframes_v3.sample(n=batch_size)
    
    batch["tree_encoded"] = sample['tree_encoded'].tolist()
    batch['condition'] = sample['condition'].tolist()
    batch['full_equation'] = sample['full_equation'].tolist()

    for i in range(batch_size):
        time = sample['time'].iloc[0][0]
        batch["times"].append(time)
        class_number = sample['class'].iloc[i]
        substrate = sample["substrate"].iloc[i]
        product = sample['product'].iloc[i]
        catalyst = sample['catalyst'].iloc[i]
        other = sample['other'].iloc[i].transpose(1,0)
        trajectory = np.concatenate((np.column_stack((substrate, product, catalyst)), other), axis=1)
        dimension = trajectory.shape[1]
        batch["trajectory"].append(trajectory)
        batch["infos"]["dimension"].append(dimension)
        batch["infos"]["class"].append(class_number)
        batch['prompt'].append(sample['prompt'].iloc[i])
    return batch

if __name__ == "__main__":
    batch = batch_generate(100)
    print(batch)



