# 
This repository provides a code for reproducing the results of Section 5.

## 5.1. Portfolio Management with a Synthetic Dataset
### EQUM
```bash
python EQUM_portfolio/equm_reinforce.py
```
- The parameter $zeta$ corresponds to "target" in the code.

### REINFORCE
```bash
python EQUM_portfolio/reinforce.py
```

### Tamar
```bash
python EQUM_portfolio/tamar_reinforce.py
```
- The parameter $var$ corresponds to "target_var" in the code.

### Xie

```bash
python EQUM_portfolio/xie_reinforce.py
```
- The parameter $\lambda$ corresponds to "lmbd" in the code.


## Appendix C. American-style Option with a Synthetic Dataset
### EQUM
```bash
python EQUM_american/equm_reinforce.py
```
- The parameter $zeta$ corresponds to "target" in the code.

### REINFORCE
```bash
python EQUM_american/reinforce.py
```

### Tamar
```bash
python EQUM_american/tamar_reinforce.py
```
- The parameter $var$ corresponds to "target_var" in the code.

### Xie
```bash
python EQUM_american/xie_reinforce.py
```
- The parameter $\lambda$ corresponds to "lmbd" in the code.

## 5.2 Portfolio Management with a Real-World Dataset
Owing to our group's privacy policy, we can not provide this code now. We will publish this code at the camera-ready. We can download the datasets from https://mba.tuck.dartmouth.edu/pages/faculty/ken.french/data_library.html. 