MODEL=${MODEL:-facebook/opt-1.3b}
MODEL_NAME=(${MODEL//\// })
MODEL_NAME="${MODEL_NAME[-1]}"

TRAINER=${TRAINER:-'zo_sgd'}
TASK=${TASK:-'RTE'}
GAUSS_RANK=${GAUSS_RANK:-8}
UPDATE_INTERVAL=${UPDATE_INTERVAL=-50}
BS=${BS:-16}
LR=${LR:-5e-7}
EPS=${EPS:-1e-3}
SEED=${SEED:-0}
TRAIN=${TRAIN:-1000}
DEV=${DEV:-500}
EVAL=${EVAL:-1000}
STEPS=${STEPS:-20000}
EVAL_STEPS=${EVAL_STEPS:-1000}
WARMUP_STEP=${WARMUP_STEP:-0}
LR_SCHEDULER_TYPE=${LR_SCHEDULER_TYPE:-'constant'}
WEIGHT_DECAY=${WEIGHT_DECAY:-0}
HESSIAN_SMOOTH_TYPE=${HESSIAN_SMOOTH_TYPE:-'constant0'}


MODE=${MODE:-ft}
EXTRA_ARGS=""
if [ "$MODE" == "prefix" ]; then
    EXTRA_ARGS="--prefix_tuning --num_prefix 5 --no_reparam --prefix_init_by_real_act"
elif [ "$MODE" == "lora" ]; then
    EXTRA_ARGS="--lora"
fi
TAG=$TRAINER-$MODE-$STEPS-$BS-$LR-$EPS-$SEED-$UPDATE_INTERVAL-$GAUSS_RANK-$HESSIAN_SMOOTH_TYPE

TASK_ARGS=""
case $TASK in
    # For Copa, ReCoRD, SQuAD, DROP, we set --train_as_classification False; for others, set this flag to True
    CB) # It has <1000 training examples. Only use 100 for dev
        DEV=100
        ;;
    Copa) # It has <1000 training examples. Only use 100 for dev
        DEV=100
        TASK_ARGS="--train_as_classification False"
        ;;
    ReCoRD) 
        TASK_ARGS="--train_as_classification False"
        ;;
    DROP) 
        TASK_ARGS="--train_as_classification False"
        ;;
    SQuAD)
        TASK_ARGS="--train_as_classification False"
        ;;
esac

echo $TAG
echo "BS: $BS"
echo "LR: $LR"
echo "EPS: $EPS"
echo "SEED: $SEED"
echo "TRAIN/EVAL STEPS: $STEPS/$EVAL_STEPS"
echo "MODE: $MODE"
echo "Extra args: $EXTRA_ARGS $TASK_ARGS"
echo "RANK: $GAUSS_RANK"
echo "UPDATE INTERVAL: $UPDATE_INTERVAL"

CUDA_VISIBLE_DEVICES=0,1 python run.py \
    --model_name $MODEL \
    --task_name $TASK \
    --output_dir result/$TASK-${MODEL_NAME}-$TAG --tag $TAG --train_set_seed $SEED --num_train $TRAIN --num_dev $DEV --num_eval $EVAL --logging_steps 10 \
    --max_steps $STEPS \
    --trainer $TRAINER --load_float16 \
    --learning_rate $LR --zo_eps $EPS --per_device_train_batch_size $BS --lr_scheduler_type "constant" \
    --load_best_model_at_end --evaluation_strategy steps --save_strategy steps --save_total_limit 1 \
    --eval_steps $EVAL_STEPS --save_steps $EVAL_STEPS \
    --warmup_step $WARMUP_STEP --lr_scheduler_type $LR_SCHEDULER_TYPE \
    --weight_decay $WEIGHT_DECAY --hessian_smooth_type $HESSIAN_SMOOTH_TYPE \
    --train_as_classification \
    --update_interval $UPDATE_INTERVAL \
    --gauss_rank $GAUSS_RANK --overwrite_output_dir\
    $EXTRA_ARGS \
    $TASK_ARGS \
    "$@"
