from typing import Literal

TaskType = Literal[
    "AMES",
    "BBB_Martins",
    "BindingDB_ic50",
    "BindingDB_kd",
    "BindingDB_ki",
    "BindingDB_Patent",
    "Bioavailability_Ma",
    "Buchwald_Hartwig",
    "butkiewicz",
    "Caco2_Wang",
    "Carcinogens_Lagunin",
    "Clearance_Hepatocyte_AZ",
    "Clearance_Microsome_AZ",
    "ClinTox",
    "CYP1A2_Veith",
    "CYP2C19_Veith",
    "CYP2C9_Substrate_CarbonMangels",
    "CYP2C9_Veith",
    "CYP2D6_Substrate_CarbonMangels",
    "CYP2D6_Veith",
    "CYP3A4_Substrate_CarbonMangels",
    "CYP3A4_Veith",
    "DAVIS",
    "DILI",
    "DisGeNET",
    "DrugComb_Bliss",
    "DrugComb_CSS",
    "DrugComb_HSA",
    "DrugComb_Loewe",
    "DrugComb_ZIP",
    "GDSC1",
    "GDSC2",
    "Half_Life_Obach",
    "herg_central",
    "hERG_Karim",
    "hERG",
    "HIA_Hou",
    "HIV",
    "HuRI",
    "KIBA",
    "LD50_Zhu",
    "Leenay",
    "Lipophilicity_AstraZeneca",
    "MHC1_IEDB_IMGT_Nielsen",
    "MHC2_IEDB_Jensen",
    "miRTarBase",
    "OncoPolyPharmacology",
    "PAMPA_NCATS",
    "Pgp_Broccatelli",
    "phase1",
    "phase2",
    "phase3",
    "PPBR_AZ",
    "Protein_SAbDab",
    "SAbDab_Chen",
    "SARSCOV2_3CLPro_Diamond",
    "SARSCoV2_Vitro_Touret",
    "Skin_Reaction",
    "Solubility_AqSolDB",
    "TAP",
    "Tox21",
    "ToxCast",
    "USPTO_Yields",
    "USPTO",
    "VDss_Lombardo",
    "weber",
]

TASK_TO_METRIC: dict[TaskType, str] = {
    "AMES": "AUROC",
    "BBB_Martins": "AUROC",
    "BindingDB_ic50": "Spearman",
    "BindingDB_kd": "PCC",
    "BindingDB_ki": "PCC",
    "BindingDB_Patent": "PCC",
    "Bioavailability_Ma": "AUROC",
    "Buchwald_Hartwig": "PCC",
    "butkiewicz": "AUROC",
    "Caco2_Wang": "MAE",
    "Carcinogens_Lagunin": "Accuracy",
    "Clearance_Hepatocyte_AZ": "Spearman",
    "Clearance_Microsome_AZ": "Spearman",
    "ClinTox": "AUROC",
    "CYP1A2_Veith": "AUPRC",
    "CYP2C19_Veith": "AUROC",
    "CYP2C9_Substrate_CarbonMangels": "AUPRC",
    "CYP2C9_Veith": "AUPRC",
    "CYP2D6_Substrate_CarbonMangels": "AUPRC",
    "CYP2D6_Veith": "AUPRC",
    "CYP3A4_Substrate_CarbonMangels": "AUROC",
    "CYP3A4_Veith": "AUPRC",
    "DAVIS": "MSE",
    "DILI": "AUROC",
    "DisGeNET": "MAE",
    "DrugComb_Bliss": "MAE",
    "DrugComb_CSS": "MAE",
    "DrugComb_HSA": "MAE",
    "DrugComb_Loewe": "MAE",
    "DrugComb_ZIP": "MAE",
    "GDSC1": "PCC",
    "GDSC2": "PCC",
    "Half_Life_Obach": "Spearman",
    "herg_central": "AUROC",
    "hERG_Karim": "Accuracy",
    "hERG": "AUROC",
    "HIA_Hou": "AUROC",
    "HIV": "AUROC",
    "HuRI": "AUPRC",
    "KIBA": "MSE",
    "LD50_Zhu": "MAE",
    "Leenay": "Spearman",
    "Lipophilicity_AstraZeneca": "MAE",
    "MHC1_IEDB_IMGT_Nielsen": "AUROC",
    "MHC2_IEDB_Jensen": "AUROC",
    "miRTarBase": "Accuracy",
    "OncoPolyPharmacology": "PCC",
    "PAMPA_NCATS": "AUROC",
    "Pgp_Broccatelli": "AUROC",
    "phase1": "AUROC",
    "phase2": "AUROC",
    "phase3": "AUROC",
    "PPBR_AZ": "MAE",
    "Protein_SAbDab": "MAE",
    "SAbDab_Chen": "AUPRC",
    "SARSCOV2_3CLPro_Diamond": "AUROC",
    "SARSCoV2_Vitro_Touret": "AUROC",
    "Skin_Reaction": "AUROC",
    "Solubility_AqSolDB": "MAE",
    "TAP": "MAE",
    "Tox21": "AUROC",
    "ToxCast": "AUROC",
    "USPTO_Yields": "PCC",
    "USPTO": "Accuracy",
    "VDss_Lombardo": "Spearman",
    "weber": "AUROC",
}
