# Dynamic Tanh (DyT) Experiments

To reproduce our results, you can run the following command to do that:

## ViT-Base
``` 
torchrun --nnodes=4 --nproc_per_node=8 main.py --model vit_base_patch16_224 --drop_path 0.1 --batch_size 128 --lr 4e-3 --update_freq 1 --model_ema true --model_ema_eval true --data_path /path_to_imagenet --output_dir /checkpoint_path --seed 0 --use_amp true  --dynamic_tanh true
```

## ConvNeXt-Base
``` 
torchrun --nnodes=4 --nproc_per_node=8 main.py --model convnext_base --drop_path 0.5 --batch_size 128 --lr 4e-3 --update_freq 1 --model_ema true --model_ema_eval true --data_path /path_to_imagenet --output_dir /checkpoint_path --seed 0 --use_amp true --dynamic_tanh true 
```

## ConvNeXt-Large
``` 
torchrun --nnodes=4 --nproc_per_node=8 main.py --model convnext_large --drop_path 0.5 --batch_size 64 --lr 4e-3 --update_freq 2 --model_ema true --model_ema_eval true --data_path /path_to_imagenet --output_dir /checkpoint_path --seed 0 --use_amp true --dynamic_tanh true
```

## Mixer-Base
``` 
torchrun --nnodes=4 --nproc_per_node=8 main.py --model mixer_b16_224 --drop_path 0.1 --batch_size 128 --lr 4e-3 --update_freq 1 --model_ema true --model_ema_eval true --data_path /path_to_imagenet --output_dir /checkpoint_path --seed 0 --clip_grad 1.0 --use_amp true --dynamic_tanh true
```
