class Callback:

    def __init__(
        self,
        before_train: list = None,
        before_epoch: list = None,
        before_step: list = None,
        after_forward: list = None,
        after_step: list = None,
        after_epoch: list = None,
        after_train: list = None,
    ):
        if before_train:
            self.before_train = __class__.compose(before_train)
        if before_epoch:
            self.before_epoch = __class__.compose(before_epoch)
        if before_step:
            self.before_step = __class__.compose(before_step)
        if after_forward:
            self.after_forward = __class__.compose(after_forward)
        if after_step:
            self.after_step = __class__.compose(after_step)
        if after_epoch:
            self.after_epoch = __class__.compose(after_epoch)
        if after_train:
            self.after_train = __class__.compose(after_train)

    def before_train(self, **kwds):
        pass

    def before_epoch(self, **kwds):
        pass

    def before_step(self, **kwds):
        pass

    def after_forward(self, **kwds):
        pass

    def after_step(self, **kwds):
        pass

    def after_epoch(self, **kwds):
        pass

    def after_train(self, **kwds):
        pass

    @staticmethod
    def compose(funcs):
        def func(**kwds):
            for _ in funcs:
                _(**kwds)  # ``kwds``: modified inplace
            return kwds

        return func
