from ..utils import register_module
from .dataset import DataLoader, ChainDataset, ConcatDataset, StackDataset
from .dataset_birds import Birds
from .dataset_clevrtex import ClevrTex
from .dataset_coco import MSCOCO
from .dataset_flowers import Flowers
from .dataset_movi import MOVi
from .dataset_pets import Pets
from .dataset_robodemo import RoboDemo, RoboDemoSlot
from .dataset_shapestacks import ShapeStacks
from .dataset_voc import PascalVOC
from .dataset_bicos import BiCoS
from .dataset_habitat import Habitat
from .dataset_ytvis import YTVIS
from .transform import (
    Compose,
    CatTokenToSlot,
    CenterResizedCrop,
    Clip,
    Filter,
    Flatten,
    Mask,
    Normalize,
    Logarithm,
    Concat,
    Rearrange,
    PadSlot,
    PadTo1,
    RandomFlip,
    RandomResizedCrop,
    RandomSlice1,
    Resize,
    Slice1,
    SliceTo1,
    StridedRandomSlice1,
    ToDevice,
    Detach,
    TupleToIndex,
    SegmentToRgb,
)

[register_module(_) for _ in locals().values() if isinstance(_, type)]
