from ..utils import register_module
from .metric import (
    ARI,
    CrossEntropyLoss,
    CrossEntropyLossGrouped,
    Entropy,
    EntropyGrouped,
    CodebookCosineSimilarity,
    UtilizLoss,
    UtilizLossGrouped,
    HuberLoss,
    KLDivLoss,
    L1Loss,
    MetricWrap,
    MSELoss,
    LPIPSLoss,
    HungarianMIoU,
    mBO,
)
from .optim import (
    Adam,
    GradScaler,
    ClipGradNorm,
    ClipGradValue,
    NAdam,
    RAdam,
    group_params_by_keys,
)
from .loop import Loop
from .callback import Callback
from .callback_log import AverageLog, SaveModel
from .callback_sched import (
    CosineAnnealing,
    CosineAnnealingConstant,
    OscillatoryCosineAnnealingConstant,
    LinearCosineAnnealing,
    ConstantCosineAnnealing,
    Squarewave,
)

[register_module(_) for _ in locals().values() if isinstance(_, type)]
