"""
Ant environment implementations for Gymnasium using MuJoCo.
This package provides various Ant-based environments with different objectives and dynamics.
"""

# Import all environment classes
from envs.base_envs import Ant, build_env, EnvRandomDiscreteActions, UniformActionSetEnv 
from envs.random_terran_envs import (
    RandomTerranAnt, AntRDir, AntRPosX, AntRNegX, AntRPosY, AntRNegY
)
from envs.directional_envs import (
    AntDir, AntPosX, AntNegX, AntPosY, AntNegY, 
)
from envs.hrl_envs import (
    MPEnv, AntMaze, MPEnvDict, make_no_ctrl_env, MPEnvCont, 
    setup_hrl_environment
)
import gymnasium as gym
# Register environments with Gymnasium
from gymnasium.envs.registration import register
import os
from dotenv import load_dotenv

# Load environment variables
load_dotenv()
BASE_XML_DIR = os.getenv('BASE_XML_DIR')

# Export all classes (make them available when importing from envs)
__all__ = [
    # Base environments
    'Ant', 'RandomTerranAnt', 'build_env',
    
    # Random discrete actions environment
    'EnvRandomDiscreteActions', 'UniformActionSetEnv',
    # Directional environments
    'AntDir', 'AntPosX', 'AntNegX', 'AntPosY', 'AntNegY',
    
    # Random Terran environments
    'AntRDir', 'AntRPosX', 'AntRNegX', 'AntRPosY', 'AntRNegY',
     
    # MP environments
    'MPEnv', 'MPEnvDict', 'setup_hrl_environment', 'AntMaze', 'MPEnvCont',
    
    'make_no_ctrl_env', 
     
]



# Environment configurations
env_configs = [
    ('ant', 'Ant'),
    ('ant_px', 'AntPosX'),
    ('ant_nx', 'AntNegX'),
    ('ant_py', 'AntPosY'),
    ('ant_ny', 'AntNegY'),
    ('antr_px', 'AntRPosX'),
    ('antr_nx', 'AntRNegX'),
    ('antr_py', 'AntRPosY'),
    ('antr_ny', 'AntRNegY'),
    ('ant_goal', 'AntGoal'),
    ('ant_maze', 'AntMaze'),
    
    ('predator_prey', 'AntPredatorPrey'),
    ('random_predator_prey', 'AntRandomPredatorPrey'),
    ('ant_corridor_predator_prey', 'AntCorridorPredatorPrey'),
    ('ant_circle_predator_prey', 'AntCirclePredatorPrey'),
    ('random_terran_ant', 'RandomTerranAnt'),
    ('random_terran_predator_prey', 'AntRandomTerranPredatorPrey'),
    ('random_terran_predator_prey_forward', 'AntRandomTerranPredatorPreyForward')
]

# Register all environments
for id, entry_point in env_configs:
    register(id=id, entry_point=f'envs:{entry_point}')



register(
    id="Hopper-v5_no_ctrl", 
    kwargs={"env_id": "Hopper-v5"},          
    entry_point="envs:make_no_ctrl_env",
)

register(
    id="Swimmer-v5_no_ctrl", 
    kwargs={"env_id": "Swimmer-v5"},          
    entry_point="envs:make_no_ctrl_env",
)

register(
    id="Walker2d-v5_no_ctrl", 
    kwargs={"env_id": "Walker2d-v5"},          
    entry_point="envs:make_no_ctrl_env",
)